package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Blueprint(
    blueprintId: Option[NonEmptyString] = None,
    name: Option[ResourceName] = None,
    group: Option[NonEmptyString] = None,
    `type`: Option[io.github.vigoo.zioaws.lightsail.model.BlueprintType] = None,
    description: Option[String] = None,
    isActive: Option[Boolean] = None,
    minPower: Option[Integer] = None,
    version: Option[String] = None,
    versionCode: Option[String] = None,
    productUrl: Option[String] = None,
    licenseUrl: Option[String] = None,
    platform: Option[io.github.vigoo.zioaws.lightsail.model.InstancePlatform] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Blueprint = {
    import Blueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Blueprint
      .builder()
      .optionallyWith(blueprintId.map(value => value: java.lang.String))(
        _.blueprintId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .optionallyWith(minPower.map(value => value: java.lang.Integer))(
        _.minPower
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(versionCode.map(value => value: java.lang.String))(
        _.versionCode
      )
      .optionallyWith(productUrl.map(value => value: java.lang.String))(
        _.productUrl
      )
      .optionallyWith(licenseUrl.map(value => value: java.lang.String))(
        _.licenseUrl
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Blueprint.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Blueprint.wrap(buildAwsValue())
}
object Blueprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Blueprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Blueprint =
      io.github.vigoo.zioaws.lightsail.model.Blueprint(
        blueprintIdValue.map(value => value),
        nameValue.map(value => value),
        groupValue.map(value => value),
        typeValue.map(value => value),
        descriptionValue.map(value => value),
        isActiveValue.map(value => value),
        minPowerValue.map(value => value),
        versionValue.map(value => value),
        versionCodeValue.map(value => value),
        productUrlValue.map(value => value),
        licenseUrlValue.map(value => value),
        platformValue.map(value => value)
      )
    def blueprintIdValue: Option[NonEmptyString]
    def nameValue: Option[ResourceName]
    def groupValue: Option[NonEmptyString]
    def typeValue: Option[io.github.vigoo.zioaws.lightsail.model.BlueprintType]
    def descriptionValue: Option[String]
    def isActiveValue: Option[Boolean]
    def minPowerValue: Option[Integer]
    def versionValue: Option[String]
    def versionCodeValue: Option[String]
    def productUrlValue: Option[String]
    def licenseUrlValue: Option[String]
    def platformValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstancePlatform]
    def blueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintId", blueprintIdValue)
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def group: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("group", groupValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.BlueprintType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def isActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActiveValue)
    def minPower: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minPower", minPowerValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
    def versionCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionCode", versionCodeValue)
    def productUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productUrl", productUrlValue)
    def licenseUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseUrl", licenseUrlValue)
    def platform: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstancePlatform
    ] = AwsError.unwrapOptionField("platform", platformValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Blueprint
  ) extends io.github.vigoo.zioaws.lightsail.model.Blueprint.ReadOnly {
    override def blueprintIdValue: Option[NonEmptyString] =
      scala.Option(impl.blueprintId()).map(value => value: NonEmptyString)
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def groupValue: Option[NonEmptyString] =
      scala.Option(impl.group()).map(value => value: NonEmptyString)
    override def typeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.BlueprintType] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.BlueprintType.wrap(value)
      )
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def isActiveValue: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
    override def minPowerValue: Option[Integer] =
      scala.Option(impl.minPower()).map(value => value: Integer)
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override def versionCodeValue: Option[String] =
      scala.Option(impl.versionCode()).map(value => value: String)
    override def productUrlValue: Option[String] =
      scala.Option(impl.productUrl()).map(value => value: String)
    override def licenseUrlValue: Option[String] =
      scala.Option(impl.licenseUrl()).map(value => value: String)
    override def platformValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstancePlatform] =
      scala
        .Option(impl.platform())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.InstancePlatform.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Blueprint
  ): io.github.vigoo.zioaws.lightsail.model.Blueprint.ReadOnly = new Wrapper(
    impl
  )
}
