package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AvailabilityZone(
    zoneName: Option[NonEmptyString] = None,
    state: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AvailabilityZone
      .builder()
      .optionallyWith(zoneName.map(value => value: java.lang.String))(
        _.zoneName
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AvailabilityZone
      .wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AvailabilityZone =
      io.github.vigoo.zioaws.lightsail.model.AvailabilityZone(
        zoneNameValue.map(value => value),
        stateValue.map(value => value)
      )
    def zoneNameValue: Option[NonEmptyString]
    def stateValue: Option[NonEmptyString]
    def zoneName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("zoneName", zoneNameValue)
    def state: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", stateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AvailabilityZone
  ) extends io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly {
    override def zoneNameValue: Option[NonEmptyString] =
      scala.Option(impl.zoneName()).map(value => value: NonEmptyString)
    override def stateValue: Option[NonEmptyString] =
      scala.Option(impl.state()).map(value => value: NonEmptyString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AvailabilityZone
  ): io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly =
    new Wrapper(impl)
}
