package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttachedDisk(
    path: Option[String] = None,
    sizeInGb: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachedDisk = {
    import AttachedDisk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachedDisk
      .builder()
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.AttachedDisk.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AttachedDisk.wrap(buildAwsValue())
}
object AttachedDisk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachedDisk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AttachedDisk =
      io.github.vigoo.zioaws.lightsail.model.AttachedDisk(
        pathValue.map(value => value),
        sizeInGbValue.map(value => value)
      )
    def pathValue: Option[String]
    def sizeInGbValue: Option[Integer]
    def path: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", pathValue)
    def sizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachedDisk
  ) extends io.github.vigoo.zioaws.lightsail.model.AttachedDisk.ReadOnly {
    override def pathValue: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override def sizeInGbValue: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachedDisk
  ): io.github.vigoo.zioaws.lightsail.model.AttachedDisk.ReadOnly = new Wrapper(
    impl
  )
}
