package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AllocateStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest = {
    import AllocateStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
      .builder()
      .staticIpName(staticIpName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpRequest
      .wrap(buildAwsValue())
}
object AllocateStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpRequest =
      io.github.vigoo.zioaws.lightsail.model
        .AllocateStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: ResourceName
    def staticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpRequest.ReadOnly {
    override def staticIpNameValue: ResourceName =
      impl.staticIpName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest
  ): io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpRequest.ReadOnly =
    new Wrapper(impl)
}
