package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddOnRequest(
    addOnType: io.github.vigoo.zioaws.lightsail.model.AddOnType,
    autoSnapshotAddOnRequest: Option[
      io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AddOnRequest = {
    import AddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOnRequest
      .builder()
      .addOnType(addOnType.unwrap)
      .optionallyWith(
        autoSnapshotAddOnRequest.map(value => value.buildAwsValue())
      )(_.autoSnapshotAddOnRequest)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AddOnRequest.wrap(buildAwsValue())
}
object AddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AddOnRequest =
      io.github.vigoo.zioaws.lightsail.model.AddOnRequest(
        addOnTypeValue,
        autoSnapshotAddOnRequestValue.map(value => value.editable)
      )
    def addOnTypeValue: io.github.vigoo.zioaws.lightsail.model.AddOnType
    def autoSnapshotAddOnRequestValue: Option[
      io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly
    ]
    def addOnType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.AddOnType] =
      ZIO.succeed(addOnTypeValue)
    def autoSnapshotAddOnRequest: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoSnapshotAddOnRequest",
      autoSnapshotAddOnRequestValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly {
    override def addOnTypeValue
        : io.github.vigoo.zioaws.lightsail.model.AddOnType =
      io.github.vigoo.zioaws.lightsail.model.AddOnType.wrap(impl.addOnType())
    override def autoSnapshotAddOnRequestValue: Option[
      io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly
    ] = scala
      .Option(impl.autoSnapshotAddOnRequest())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.AutoSnapshotAddOnRequest
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ): io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly = new Wrapper(
    impl
  )
}
