package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait AccessType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AccessType
}
object AccessType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AccessType
  ): io.github.vigoo.zioaws.lightsail.model.AccessType = value match {
    case software.amazon.awssdk.services.lightsail.model.AccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AccessType.PUBLIC =>
      val r = public
      r
    case software.amazon.awssdk.services.lightsail.model.AccessType.PRIVATE =>
      val r = `private`
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessType =
      software.amazon.awssdk.services.lightsail.model.AccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object public extends io.github.vigoo.zioaws.lightsail.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessType =
      software.amazon.awssdk.services.lightsail.model.AccessType.PUBLIC
  }
  case object `private`
      extends io.github.vigoo.zioaws.lightsail.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessType =
      software.amazon.awssdk.services.lightsail.model.AccessType.PRIVATE
  }
}
