package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  IAMAccessKeyId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccessKey(
    accessKeyId: Option[IAMAccessKeyId] = None,
    secretAccessKey: Option[NonEmptyString] = None,
    status: Option[io.github.vigoo.zioaws.lightsail.model.StatusType] = None,
    createdAt: Option[IsoDate] = None,
    lastUsed: Option[io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AccessKey = {
    import AccessKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessKey
      .builder()
      .optionallyWith(accessKeyId.map(value => value: java.lang.String))(
        _.accessKeyId
      )
      .optionallyWith(secretAccessKey.map(value => value: java.lang.String))(
        _.secretAccessKey
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(lastUsed.map(value => value.buildAwsValue()))(_.lastUsed)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AccessKey.wrap(buildAwsValue())
}
object AccessKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AccessKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AccessKey =
      io.github.vigoo.zioaws.lightsail.model.AccessKey(
        accessKeyIdValue.map(value => value),
        secretAccessKeyValue.map(value => value),
        statusValue.map(value => value),
        createdAtValue.map(value => value),
        lastUsedValue.map(value => value.editable)
      )
    def accessKeyIdValue: Option[IAMAccessKeyId]
    def secretAccessKeyValue: Option[NonEmptyString]
    def statusValue: Option[io.github.vigoo.zioaws.lightsail.model.StatusType]
    def createdAtValue: Option[IsoDate]
    def lastUsedValue: Option[
      io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed.ReadOnly
    ]
    def accessKeyId: ZIO[Any, AwsError, IAMAccessKeyId] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyIdValue)
    def secretAccessKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKeyValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.StatusType
    ] = AwsError.unwrapOptionField("status", statusValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def lastUsed: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed.ReadOnly
    ] = AwsError.unwrapOptionField("lastUsed", lastUsedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKey
  ) extends io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly {
    override def accessKeyIdValue: Option[IAMAccessKeyId] =
      scala.Option(impl.accessKeyId()).map(value => value: IAMAccessKeyId)
    override def secretAccessKeyValue: Option[NonEmptyString] =
      scala.Option(impl.secretAccessKey()).map(value => value: NonEmptyString)
    override def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.StatusType] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.StatusType.wrap(value)
      )
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def lastUsedValue: Option[
      io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed.ReadOnly
    ] = scala
      .Option(impl.lastUsed())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.AccessKeyLastUsed.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKey
  ): io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly = new Wrapper(
    impl
  )
}
