package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse.ReadOnly
import io.github.vigoo.zioaws.lightsail.model.{
  GetOperationsForResourceRequest,
  AttachStaticIpRequest,
  DeleteDiskSnapshotRequest,
  GetBucketsRequest,
  CreateContainerServiceRegistryLoginRequest,
  GetRelationalDatabaseSnapshotsRequest,
  DisableAddOnRequest,
  DetachCertificateFromDistributionRequest,
  CreateDistributionRequest,
  DeleteLoadBalancerTlsCertificateRequest,
  GetDistributionMetricDataRequest,
  GetOperationsRequest,
  GetCloudFormationStackRecordsRequest,
  GetRelationalDatabaseBlueprintsRequest,
  GetDiskSnapshotsRequest,
  DeleteDistributionRequest,
  UpdateContainerServiceRequest,
  GetDiskRequest,
  GetKeyPairRequest,
  DeleteContainerImageRequest,
  CreateRelationalDatabaseSnapshotRequest,
  GetContactMethodsRequest,
  DeleteAlarmRequest,
  CreateContainerServiceDeploymentRequest,
  IsVpcPeeredRequest,
  GetBucketBundlesRequest,
  DeleteKeyPairRequest,
  StopInstanceRequest,
  CreateRelationalDatabaseRequest,
  GetLoadBalancerRequest,
  AttachDiskRequest,
  GetInstanceAccessDetailsRequest,
  UpdateDistributionBundleRequest,
  CreateBucketAccessKeyRequest,
  CloseInstancePublicPortsRequest,
  GetAutoSnapshotsRequest,
  GetInstanceRequest,
  AllocateStaticIpRequest,
  AttachCertificateToDistributionRequest,
  UnpeerVpcRequest,
  ResetDistributionCacheRequest,
  CreateContainerServiceRequest,
  GetBundlesRequest,
  CreateCloudFormationStackRequest,
  GetContainerApiMetadataRequest,
  GetOperationRequest,
  DetachDiskRequest,
  PutAlarmRequest,
  DeleteDomainEntryRequest,
  ExportSnapshotRequest,
  CreateDiskSnapshotRequest,
  AttachLoadBalancerTlsCertificateRequest,
  GetInstanceSnapshotRequest,
  GetRelationalDatabaseEventsRequest,
  DetachStaticIpRequest,
  CopySnapshotRequest,
  SetIpAddressTypeRequest,
  RegisterContainerImageRequest,
  GetContainerImagesRequest,
  GetRelationalDatabaseRequest,
  DeleteRelationalDatabaseRequest,
  DownloadDefaultKeyPairRequest,
  CreateCertificateRequest,
  SendContactMethodVerificationRequest,
  StartRelationalDatabaseRequest,
  GetInstanceMetricDataRequest,
  UpdateLoadBalancerAttributeRequest,
  CreateRelationalDatabaseFromSnapshotRequest,
  GetInstanceSnapshotsRequest,
  GetCertificatesRequest,
  AttachInstancesToLoadBalancerRequest,
  CreateDomainEntryRequest,
  PutInstancePublicPortsRequest,
  DeleteDiskRequest,
  GetLoadBalancersRequest,
  DeleteBucketAccessKeyRequest,
  RebootRelationalDatabaseRequest,
  OpenInstancePublicPortsRequest,
  DeleteInstanceSnapshotRequest,
  CreateInstanceSnapshotRequest,
  GetDistributionBundlesRequest,
  GetInstancePortStatesRequest,
  GetLoadBalancerMetricDataRequest,
  GetRelationalDatabaseParametersRequest,
  DeleteDomainRequest,
  GetLoadBalancerTlsCertificatesRequest,
  DeleteRelationalDatabaseSnapshotRequest,
  GetAlarmsRequest,
  GetContainerLogRequest,
  GetContainerServicePowersRequest,
  DeleteBucketRequest,
  GetRelationalDatabaseSnapshotRequest,
  GetContainerServicesRequest,
  DeleteContactMethodRequest,
  CreateDiskFromSnapshotRequest,
  CreateLoadBalancerRequest,
  CreateKeyPairRequest,
  DeleteKnownHostKeysRequest,
  DeleteAutoSnapshotRequest,
  GetRelationalDatabaseMasterUserPasswordRequest,
  GetBlueprintsRequest,
  UpdateDomainEntryRequest,
  DetachInstancesFromLoadBalancerRequest,
  UpdateDistributionRequest,
  CreateContactMethodRequest,
  CreateBucketRequest,
  GetInstancesRequest,
  GetRelationalDatabaseLogEventsRequest,
  StopRelationalDatabaseRequest,
  DeleteLoadBalancerRequest,
  CreateDomainRequest,
  GetRelationalDatabaseMetricDataRequest,
  GetDomainsRequest,
  GetInstanceStateRequest,
  UntagResourceRequest,
  SetResourceAccessForBucketRequest,
  GetBucketAccessKeysRequest,
  DeleteInstanceRequest,
  GetRelationalDatabaseLogStreamsRequest,
  CreateLoadBalancerTlsCertificateRequest,
  UpdateRelationalDatabaseParametersRequest,
  GetStaticIpRequest,
  UpdateBucketBundleRequest,
  GetContainerServiceMetricDataRequest,
  DeleteContainerServiceRequest,
  PeerVpcRequest,
  GetDomainRequest,
  GetRelationalDatabaseBundlesRequest,
  GetKeyPairsRequest,
  GetDistributionsRequest,
  ReleaseStaticIpRequest,
  UpdateRelationalDatabaseRequest,
  RebootInstanceRequest,
  CreateInstancesRequest,
  GetDistributionLatestCacheResetRequest,
  GetStaticIpsRequest,
  CreateInstancesFromSnapshotRequest,
  UpdateBucketRequest,
  GetDisksRequest,
  GetBucketMetricDataRequest,
  EnableAddOnRequest,
  ImportKeyPairRequest,
  GetRegionsRequest,
  GetExportSnapshotRecordsRequest,
  GetDiskSnapshotRequest,
  TestAlarmRequest,
  StartInstanceRequest,
  DeleteCertificateRequest,
  TagResourceRequest,
  GetContainerServiceDeploymentsRequest,
  CreateDiskRequest,
  GetRelationalDatabasesRequest,
  GetActiveNamesRequest
}
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.lightsail.{
  LightsailAsyncClientBuilder,
  LightsailAsyncClient
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.lightsail.Lightsail
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import software.amazon.awssdk.services.lightsail.model.{
  UpdateRelationalDatabaseResponse,
  CreateInstancesFromSnapshotResponse,
  GetDomainsResponse,
  StartRelationalDatabaseResponse,
  DeleteRelationalDatabaseSnapshotResponse,
  SendContactMethodVerificationResponse,
  GetOperationsResponse,
  RegisterContainerImageResponse,
  ImportKeyPairResponse,
  GetDomainResponse,
  GetAlarmsResponse,
  GetRelationalDatabaseBundlesResponse,
  GetBundlesResponse,
  CreateRelationalDatabaseResponse,
  CloseInstancePublicPortsResponse,
  GetRelationalDatabasesResponse,
  GetRelationalDatabaseMasterUserPasswordResponse,
  GetKeyPairsResponse,
  CreateCertificateResponse,
  DeleteDiskSnapshotResponse,
  CreateContainerServiceRegistryLoginResponse,
  UpdateBucketBundleResponse,
  GetActiveNamesResponse,
  CreateContactMethodResponse,
  CreateDomainResponse,
  GetLoadBalancersResponse,
  GetInstanceSnapshotResponse,
  GetDistributionLatestCacheResetResponse,
  CreateCloudFormationStackResponse,
  GetInstanceMetricDataResponse,
  StopInstanceResponse,
  GetInstancePortStatesResponse,
  UpdateBucketResponse,
  AttachInstancesToLoadBalancerResponse,
  DisableAddOnResponse,
  GetRelationalDatabaseSnapshotResponse,
  CreateContainerServiceResponse,
  GetDisksResponse,
  RebootInstanceResponse,
  DeleteBucketAccessKeyResponse,
  SetIpAddressTypeResponse,
  GetLoadBalancerResponse,
  CreateInstancesResponse,
  DeleteInstanceSnapshotResponse,
  GetInstanceResponse,
  DeleteAutoSnapshotResponse,
  CreateDiskSnapshotResponse,
  UpdateRelationalDatabaseParametersResponse,
  GetRelationalDatabaseResponse,
  UpdateDomainEntryResponse,
  CreateContainerServiceDeploymentResponse,
  UnpeerVpcResponse,
  CreateRelationalDatabaseSnapshotResponse,
  GetExportSnapshotRecordsResponse,
  DeleteCertificateResponse,
  DeleteAlarmResponse,
  DeleteLoadBalancerResponse,
  GetDiskResponse,
  GetCloudFormationStackRecordsResponse,
  UpdateDistributionBundleResponse,
  GetInstanceSnapshotsResponse,
  DeleteDistributionResponse,
  CreateBucketResponse,
  GetDistributionBundlesResponse,
  GetDiskSnapshotResponse,
  GetStaticIpResponse,
  DeleteBucketResponse,
  GetLoadBalancerMetricDataResponse,
  DeleteInstanceResponse,
  UpdateLoadBalancerAttributeResponse,
  GetDiskSnapshotsResponse,
  GetStaticIpsResponse,
  CreateDomainEntryResponse,
  DeleteContainerImageResponse,
  ExportSnapshotResponse,
  CreateBucketAccessKeyResponse,
  CreateDiskFromSnapshotResponse,
  DownloadDefaultKeyPairResponse,
  GetDistributionMetricDataResponse,
  TestAlarmResponse,
  AttachStaticIpResponse,
  UntagResourceResponse,
  GetInstanceStateResponse,
  UpdateDistributionResponse,
  AllocateStaticIpResponse,
  AttachCertificateToDistributionResponse,
  DeleteRelationalDatabaseResponse,
  GetBlueprintsResponse,
  GetRelationalDatabaseBlueprintsResponse,
  GetContainerServicesResponse,
  StopRelationalDatabaseResponse,
  DetachInstancesFromLoadBalancerResponse,
  PeerVpcResponse,
  CreateInstanceSnapshotResponse,
  CreateDiskResponse,
  GetOperationResponse,
  GetRegionsResponse,
  DetachDiskResponse,
  GetRelationalDatabaseSnapshotsResponse,
  CreateLoadBalancerResponse,
  GetContainerServiceDeploymentsResponse,
  GetAutoSnapshotsResponse,
  PutAlarmResponse,
  AttachDiskResponse,
  CopySnapshotResponse,
  GetContactMethodsResponse,
  DeleteContactMethodResponse,
  DeleteContainerServiceResponse,
  DetachCertificateFromDistributionResponse,
  EnableAddOnResponse,
  GetRelationalDatabaseLogEventsResponse,
  GetCertificatesResponse,
  GetRelationalDatabaseMetricDataResponse,
  GetContainerApiMetadataResponse,
  DeleteKeyPairResponse,
  GetLoadBalancerTlsCertificatesResponse,
  OpenInstancePublicPortsResponse,
  PutInstancePublicPortsResponse,
  SetResourceAccessForBucketResponse,
  GetContainerImagesResponse,
  GetRelationalDatabaseParametersResponse,
  RebootRelationalDatabaseResponse,
  GetInstanceAccessDetailsResponse,
  AttachLoadBalancerTlsCertificateResponse,
  GetKeyPairResponse,
  GetContainerServicePowersResponse,
  GetRelationalDatabaseEventsResponse,
  IsVpcPeeredResponse,
  GetDistributionsResponse,
  CreateRelationalDatabaseFromSnapshotResponse,
  GetContainerLogResponse,
  GetBucketsResponse,
  ResetDistributionCacheResponse,
  CreateLoadBalancerTlsCertificateResponse,
  StartInstanceResponse,
  UpdateContainerServiceResponse,
  CreateDistributionResponse,
  GetRelationalDatabaseLogStreamsResponse,
  DetachStaticIpResponse,
  GetBucketAccessKeysResponse,
  TagResourceResponse,
  DeleteKnownHostKeysResponse,
  DeleteDiskResponse,
  DeleteLoadBalancerTlsCertificateResponse,
  GetOperationsForResourceResponse,
  DeleteDomainEntryResponse,
  ReleaseStaticIpResponse,
  GetBucketBundlesResponse,
  CreateKeyPairResponse,
  DeleteDomainResponse,
  GetContainerServiceMetricDataResponse,
  GetInstancesResponse,
  GetBucketMetricDataResponse
}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.test.mock.{Proxy, Mock}
package object lightsail {
  import scala.jdk.CollectionConverters.*
  type Lightsail = Has[Lightsail.Service]
  object Lightsail {
    trait Service extends AspectSupport[Service] {
      val api: LightsailAsyncClient
      def putInstancePublicPorts(request: PutInstancePublicPortsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
      ]
      def resetDistributionCache(request: ResetDistributionCacheRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
      ]
      def getRelationalDatabaseSnapshot(
          request: GetRelationalDatabaseSnapshotRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
      ]
      def getKeyPair(request: GetKeyPairRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly
      ]
      def getInstanceAccessDetails(
          request: GetInstanceAccessDetailsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
      ]
      def deleteLoadBalancerTlsCertificate(
          request: DeleteLoadBalancerTlsCertificateRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
      ]
      def createDiskSnapshot(request: CreateDiskSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
      ]
      def deleteRelationalDatabase(
          request: DeleteRelationalDatabaseRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
      ]
      def releaseStaticIp(request: ReleaseStaticIpRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
      ]
      def updateLoadBalancerAttribute(
          request: UpdateLoadBalancerAttributeRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
      ]
      def testAlarm(request: TestAlarmRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.TestAlarmResponse.ReadOnly
      ]
      def closeInstancePublicPorts(
          request: CloseInstancePublicPortsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
      ]
      def deleteContactMethod(request: DeleteContactMethodRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodResponse.ReadOnly
      ]
      def deleteDiskSnapshot(request: DeleteDiskSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
      ]
      def putAlarm(request: PutAlarmRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.PutAlarmResponse.ReadOnly
      ]
      def getInstances(request: GetInstancesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly
      ]
      def createCertificate(request: CreateCertificateRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly
      ]
      def getRelationalDatabaseLogEvents(
          request: GetRelationalDatabaseLogEventsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
      ]
      def deleteKnownHostKeys(request: DeleteKnownHostKeysRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
      ]
      def rebootRelationalDatabase(
          request: RebootRelationalDatabaseRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
      ]
      def createCloudFormationStack(
          request: CreateCloudFormationStackRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
      ]
      def getBucketMetricData(request: GetBucketMetricDataRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
      ]
      def detachDisk(request: DetachDiskRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DetachDiskResponse.ReadOnly
      ]
      def allocateStaticIp(request: AllocateStaticIpRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpResponse.ReadOnly
      ]
      def getRelationalDatabaseEvents(
          request: GetRelationalDatabaseEventsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
      ]
      def getOperations(request: GetOperationsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetOperationsResponse.ReadOnly
      ]
      def getInstanceState(request: GetInstanceStateRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly
      ]
      def getDomains(request: GetDomainsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly
      ]
      def getLoadBalancers(request: GetLoadBalancersRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly
      ]
      def getContainerServices(request: GetContainerServicesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly
      ]
      def getLoadBalancerTlsCertificates(
          request: GetLoadBalancerTlsCertificatesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
      ]
      def createRelationalDatabaseFromSnapshot(
          request: CreateRelationalDatabaseFromSnapshotRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
      ]
      def getInstanceSnapshot(request: GetInstanceSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
      ]
      def deleteContainerService(request: DeleteContainerServiceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
      ]
      def getContainerAPIMetadata(request: GetContainerApiMetadataRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
      ]
      def getDiskSnapshot(request: GetDiskSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
      ]
      def detachStaticIp(request: DetachStaticIpRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DetachStaticIpResponse.ReadOnly
      ]
      def createDisk(request: CreateDiskRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateDiskResponse.ReadOnly
      ]
      def getContainerImages(request: GetContainerImagesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly
      ]
      def deleteBucketAccessKey(request: DeleteBucketAccessKeyRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
      ]
      def createDomainEntry(request: CreateDomainEntryRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly
      ]
      def sendContactMethodVerification(
          request: SendContactMethodVerificationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
      ]
      def getDomain(request: GetDomainRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly
      ]
      def deleteInstance(request: DeleteInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteInstanceResponse.ReadOnly
      ]
      def copySnapshot(request: CopySnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CopySnapshotResponse.ReadOnly
      ]
      def getContactMethods(request: GetContactMethodsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly
      ]
      def getRelationalDatabaseBundles(
          request: GetRelationalDatabaseBundlesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
      ]
      def detachInstancesFromLoadBalancer(
          request: DetachInstancesFromLoadBalancerRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
      ]
      def openInstancePublicPorts(request: OpenInstancePublicPortsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
      ]
      def getInstanceMetricData(request: GetInstanceMetricDataRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
      ]
      def deleteRelationalDatabaseSnapshot(
          request: DeleteRelationalDatabaseSnapshotRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
      ]
      def attachInstancesToLoadBalancer(
          request: AttachInstancesToLoadBalancerRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
      ]
      def getDistributionBundles(request: GetDistributionBundlesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
      ]
      def getRelationalDatabaseParameters(
          request: GetRelationalDatabaseParametersRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
      ]
      def getAlarms(request: GetAlarmsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly
      ]
      def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
      ]
      def getInstanceSnapshots(request: GetInstanceSnapshotsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
      ]
      def stopRelationalDatabase(request: StopRelationalDatabaseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
      ]
      def getLoadBalancerMetricData(
          request: GetLoadBalancerMetricDataRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
      ]
      def attachCertificateToDistribution(
          request: AttachCertificateToDistributionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
      ]
      def deleteCertificate(request: DeleteCertificateRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteCertificateResponse.ReadOnly
      ]
      def getInstance(request: GetInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly
      ]
      def getDistributions(request: GetDistributionsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly
      ]
      def getRelationalDatabases(request: GetRelationalDatabasesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
      ]
      def attachLoadBalancerTlsCertificate(
          request: AttachLoadBalancerTlsCertificateRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
      ]
      def getOperationsForResource(
          request: GetOperationsForResourceRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
      ]
      def createDiskFromSnapshot(request: CreateDiskFromSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
      ]
      def getLoadBalancer(request: GetLoadBalancerRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly
      ]
      def getBucketBundles(request: GetBucketBundlesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly
      ]
      def deleteInstanceSnapshot(request: DeleteInstanceSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
      ]
      def deleteDomainEntry(request: DeleteDomainEntryRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
      ]
      def updateRelationalDatabase(
          request: UpdateRelationalDatabaseRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
      ]
      def peerVpc(request: PeerVpcRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.PeerVpcResponse.ReadOnly
      ]
      def unpeerVpc(request: UnpeerVpcRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UnpeerVpcResponse.ReadOnly
      ]
      def getActiveNames(request: GetActiveNamesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly
      ]
      def deleteBucket(request: DeleteBucketRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteBucketResponse.ReadOnly
      ]
      def getAutoSnapshots(request: GetAutoSnapshotsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
      ]
      def startRelationalDatabase(request: StartRelationalDatabaseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
      ]
      def createInstanceSnapshot(request: CreateInstanceSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
      ]
      def updateDomainEntry(request: UpdateDomainEntryRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
      ]
      def updateBucket(request: UpdateBucketRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateBucketResponse.ReadOnly
      ]
      def rebootInstance(request: RebootInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.RebootInstanceResponse.ReadOnly
      ]
      def createContactMethod(request: CreateContactMethodRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateContactMethodResponse.ReadOnly
      ]
      def getDiskSnapshots(request: GetDiskSnapshotsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
      ]
      def createBucket(request: CreateBucketRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly
      ]
      def getContainerLog(request: GetContainerLogRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly
      ]
      def getContainerServiceDeployments(
          request: GetContainerServiceDeploymentsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
      ]
      def createDomain(request: CreateDomainRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateDomainResponse.ReadOnly
      ]
      def setResourceAccessForBucket(
          request: SetResourceAccessForBucketRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
      ]
      def getBucketAccessKeys(request: GetBucketAccessKeysRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
      ]
      def createContainerService(request: CreateContainerServiceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly
      ]
      def isVpcPeered(request: IsVpcPeeredRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly
      ]
      def deleteAutoSnapshot(request: DeleteAutoSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
      ]
      def createContainerServiceRegistryLogin(
          request: CreateContainerServiceRegistryLoginRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
      ]
      def getDisk(request: GetDiskRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly
      ]
      def enableAddOn(request: EnableAddOnRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.EnableAddOnResponse.ReadOnly
      ]
      def untagResource(request: UntagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly
      ]
      def createLoadBalancerTlsCertificate(
          request: CreateLoadBalancerTlsCertificateRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
      ]
      def getStaticIp(request: GetStaticIpRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly
      ]
      def attachStaticIp(request: AttachStaticIpRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.AttachStaticIpResponse.ReadOnly
      ]
      def importKeyPair(request: ImportKeyPairRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly
      ]
      def getDisks(request: GetDisksRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly
      ]
      def downloadDefaultKeyPair(request: DownloadDefaultKeyPairRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
      ]
      def getExportSnapshotRecords(
          request: GetExportSnapshotRecordsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
      ]
      def createKeyPair(request: CreateKeyPairRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly
      ]
      def getBundles(request: GetBundlesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly
      ]
      def registerContainerImage(request: RegisterContainerImageRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly
      ]
      def startInstance(request: StartInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.StartInstanceResponse.ReadOnly
      ]
      def getInstancePortStates(request: GetInstancePortStatesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
      ]
      def deleteDisk(request: DeleteDiskRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteDiskResponse.ReadOnly
      ]
      def getBlueprints(request: GetBlueprintsRequest): IO[AwsError, ReadOnly]
      def deleteAlarm(request: DeleteAlarmRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteAlarmResponse.ReadOnly
      ]
      def createRelationalDatabaseSnapshot(
          request: CreateRelationalDatabaseSnapshotRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
      ]
      def getContainerServiceMetricData(
          request: GetContainerServiceMetricDataRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
      ]
      def getRelationalDatabaseLogStreams(
          request: GetRelationalDatabaseLogStreamsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
      ]
      def updateRelationalDatabaseParameters(
          request: UpdateRelationalDatabaseParametersRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
      ]
      def createContainerServiceDeployment(
          request: CreateContainerServiceDeploymentRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
      ]
      def getDistributionLatestCacheReset(
          request: GetDistributionLatestCacheResetRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
      ]
      def updateDistributionBundle(
          request: UpdateDistributionBundleRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
      ]
      def deleteKeyPair(request: DeleteKeyPairRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairResponse.ReadOnly
      ]
      def updateBucketBundle(request: UpdateBucketBundleRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
      ]
      def getStaticIps(request: GetStaticIpsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly
      ]
      def createRelationalDatabase(
          request: CreateRelationalDatabaseRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
      ]
      def getCertificates(request: GetCertificatesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly
      ]
      def tagResource(request: TagResourceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.TagResourceResponse.ReadOnly
      ]
      def deleteDomain(request: DeleteDomainRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteDomainResponse.ReadOnly
      ]
      def createBucketAccessKey(request: CreateBucketAccessKeyRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
      ]
      def getRelationalDatabaseSnapshots(
          request: GetRelationalDatabaseSnapshotsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
      ]
      def createInstancesFromSnapshot(
          request: CreateInstancesFromSnapshotRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
      ]
      def exportSnapshot(request: ExportSnapshotRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.ExportSnapshotResponse.ReadOnly
      ]
      def attachDisk(request: AttachDiskRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.AttachDiskResponse.ReadOnly
      ]
      def setIpAddressType(request: SetIpAddressTypeRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
      ]
      def getRegions(request: GetRegionsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly
      ]
      def getRelationalDatabaseMetricData(
          request: GetRelationalDatabaseMetricDataRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
      ]
      def getOperation(request: GetOperationRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetOperationResponse.ReadOnly
      ]
      def stopInstance(request: StopInstanceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.StopInstanceResponse.ReadOnly
      ]
      def getDistributionMetricData(
          request: GetDistributionMetricDataRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
      ]
      def getKeyPairs(request: GetKeyPairsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly
      ]
      def disableAddOn(request: DisableAddOnRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DisableAddOnResponse.ReadOnly
      ]
      def createInstances(request: CreateInstancesRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateInstancesResponse.ReadOnly
      ]
      def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
      ]
      def getRelationalDatabaseBlueprints(
          request: GetRelationalDatabaseBlueprintsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
      ]
      def detachCertificateFromDistribution(
          request: DetachCertificateFromDistributionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
      ]
      def getRelationalDatabaseMasterUserPassword(
          request: GetRelationalDatabaseMasterUserPasswordRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
      ]
      def updateContainerService(request: UpdateContainerServiceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
      ]
      def getContainerServicePowers(
          request: GetContainerServicePowersRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
      ]
      def getRelationalDatabase(request: GetRelationalDatabaseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
      ]
      def getBuckets(request: GetBucketsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly
      ]
      def getCloudFormationStackRecords(
          request: GetCloudFormationStackRecordsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
      ]
      def updateDistribution(request: UpdateDistributionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly
      ]
      def deleteDistribution(request: DeleteDistributionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteDistributionResponse.ReadOnly
      ]
      def deleteContainerImage(request: DeleteContainerImageRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageResponse.ReadOnly
      ]
      def createDistribution(request: CreateDistributionRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly
      ]
    }
    object LightsailMock extends Mock[Lightsail] {
      object PutInstancePublicPorts
          extends Effect[
            PutInstancePublicPortsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
          ]
      object ResetDistributionCache
          extends Effect[
            ResetDistributionCacheRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
          ]
      object GetRelationalDatabaseSnapshot
          extends Effect[
            GetRelationalDatabaseSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
          ]
      object GetKeyPair
          extends Effect[
            GetKeyPairRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly
          ]
      object GetInstanceAccessDetails
          extends Effect[
            GetInstanceAccessDetailsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
          ]
      object DeleteLoadBalancerTlsCertificate
          extends Effect[
            DeleteLoadBalancerTlsCertificateRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
          ]
      object CreateDiskSnapshot
          extends Effect[
            CreateDiskSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
          ]
      object DeleteRelationalDatabase
          extends Effect[
            DeleteRelationalDatabaseRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
          ]
      object ReleaseStaticIp
          extends Effect[
            ReleaseStaticIpRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
          ]
      object UpdateLoadBalancerAttribute
          extends Effect[
            UpdateLoadBalancerAttributeRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
          ]
      object TestAlarm
          extends Effect[
            TestAlarmRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.TestAlarmResponse.ReadOnly
          ]
      object CloseInstancePublicPorts
          extends Effect[
            CloseInstancePublicPortsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
          ]
      object DeleteContactMethod
          extends Effect[
            DeleteContactMethodRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodResponse.ReadOnly
          ]
      object DeleteDiskSnapshot
          extends Effect[
            DeleteDiskSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
          ]
      object PutAlarm
          extends Effect[
            PutAlarmRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.PutAlarmResponse.ReadOnly
          ]
      object GetInstances
          extends Effect[
            GetInstancesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly
          ]
      object CreateCertificate
          extends Effect[
            CreateCertificateRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly
          ]
      object GetRelationalDatabaseLogEvents
          extends Effect[
            GetRelationalDatabaseLogEventsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
          ]
      object DeleteKnownHostKeys
          extends Effect[
            DeleteKnownHostKeysRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
          ]
      object RebootRelationalDatabase
          extends Effect[
            RebootRelationalDatabaseRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
          ]
      object CreateCloudFormationStack
          extends Effect[
            CreateCloudFormationStackRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
          ]
      object GetBucketMetricData
          extends Effect[
            GetBucketMetricDataRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
          ]
      object DetachDisk
          extends Effect[
            DetachDiskRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DetachDiskResponse.ReadOnly
          ]
      object AllocateStaticIp
          extends Effect[
            AllocateStaticIpRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpResponse.ReadOnly
          ]
      object GetRelationalDatabaseEvents
          extends Effect[
            GetRelationalDatabaseEventsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
          ]
      object GetOperations
          extends Effect[
            GetOperationsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetOperationsResponse.ReadOnly
          ]
      object GetInstanceState
          extends Effect[
            GetInstanceStateRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly
          ]
      object GetDomains
          extends Effect[
            GetDomainsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly
          ]
      object GetLoadBalancers
          extends Effect[
            GetLoadBalancersRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly
          ]
      object GetContainerServices
          extends Effect[
            GetContainerServicesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly
          ]
      object GetLoadBalancerTlsCertificates
          extends Effect[
            GetLoadBalancerTlsCertificatesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
          ]
      object CreateRelationalDatabaseFromSnapshot
          extends Effect[
            CreateRelationalDatabaseFromSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
          ]
      object GetInstanceSnapshot
          extends Effect[
            GetInstanceSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
          ]
      object DeleteContainerService
          extends Effect[
            DeleteContainerServiceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
          ]
      object GetContainerAPIMetadata
          extends Effect[
            GetContainerApiMetadataRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
          ]
      object GetDiskSnapshot
          extends Effect[
            GetDiskSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
          ]
      object DetachStaticIp
          extends Effect[
            DetachStaticIpRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DetachStaticIpResponse.ReadOnly
          ]
      object CreateDisk
          extends Effect[
            CreateDiskRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateDiskResponse.ReadOnly
          ]
      object GetContainerImages
          extends Effect[
            GetContainerImagesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly
          ]
      object DeleteBucketAccessKey
          extends Effect[
            DeleteBucketAccessKeyRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
          ]
      object CreateDomainEntry
          extends Effect[
            CreateDomainEntryRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly
          ]
      object SendContactMethodVerification
          extends Effect[
            SendContactMethodVerificationRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
          ]
      object GetDomain
          extends Effect[
            GetDomainRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly
          ]
      object DeleteInstance
          extends Effect[
            DeleteInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteInstanceResponse.ReadOnly
          ]
      object CopySnapshot
          extends Effect[
            CopySnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CopySnapshotResponse.ReadOnly
          ]
      object GetContactMethods
          extends Effect[
            GetContactMethodsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly
          ]
      object GetRelationalDatabaseBundles
          extends Effect[
            GetRelationalDatabaseBundlesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
          ]
      object DetachInstancesFromLoadBalancer
          extends Effect[
            DetachInstancesFromLoadBalancerRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
          ]
      object OpenInstancePublicPorts
          extends Effect[
            OpenInstancePublicPortsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
          ]
      object GetInstanceMetricData
          extends Effect[
            GetInstanceMetricDataRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
          ]
      object DeleteRelationalDatabaseSnapshot
          extends Effect[
            DeleteRelationalDatabaseSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
          ]
      object AttachInstancesToLoadBalancer
          extends Effect[
            AttachInstancesToLoadBalancerRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
          ]
      object GetDistributionBundles
          extends Effect[
            GetDistributionBundlesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
          ]
      object GetRelationalDatabaseParameters
          extends Effect[
            GetRelationalDatabaseParametersRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
          ]
      object GetAlarms
          extends Effect[
            GetAlarmsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly
          ]
      object DeleteLoadBalancer
          extends Effect[
            DeleteLoadBalancerRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
          ]
      object GetInstanceSnapshots
          extends Effect[
            GetInstanceSnapshotsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
          ]
      object StopRelationalDatabase
          extends Effect[
            StopRelationalDatabaseRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
          ]
      object GetLoadBalancerMetricData
          extends Effect[
            GetLoadBalancerMetricDataRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
          ]
      object AttachCertificateToDistribution
          extends Effect[
            AttachCertificateToDistributionRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
          ]
      object DeleteCertificate
          extends Effect[
            DeleteCertificateRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteCertificateResponse.ReadOnly
          ]
      object GetInstance
          extends Effect[
            GetInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly
          ]
      object GetDistributions
          extends Effect[
            GetDistributionsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly
          ]
      object GetRelationalDatabases
          extends Effect[
            GetRelationalDatabasesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
          ]
      object AttachLoadBalancerTlsCertificate
          extends Effect[
            AttachLoadBalancerTlsCertificateRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
          ]
      object GetOperationsForResource
          extends Effect[
            GetOperationsForResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
          ]
      object CreateDiskFromSnapshot
          extends Effect[
            CreateDiskFromSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
          ]
      object GetLoadBalancer
          extends Effect[
            GetLoadBalancerRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly
          ]
      object GetBucketBundles
          extends Effect[
            GetBucketBundlesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly
          ]
      object DeleteInstanceSnapshot
          extends Effect[
            DeleteInstanceSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
          ]
      object DeleteDomainEntry
          extends Effect[
            DeleteDomainEntryRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
          ]
      object UpdateRelationalDatabase
          extends Effect[
            UpdateRelationalDatabaseRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
          ]
      object PeerVpc
          extends Effect[
            PeerVpcRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.PeerVpcResponse.ReadOnly
          ]
      object UnpeerVpc
          extends Effect[
            UnpeerVpcRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UnpeerVpcResponse.ReadOnly
          ]
      object GetActiveNames
          extends Effect[
            GetActiveNamesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly
          ]
      object DeleteBucket
          extends Effect[
            DeleteBucketRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteBucketResponse.ReadOnly
          ]
      object GetAutoSnapshots
          extends Effect[
            GetAutoSnapshotsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
          ]
      object StartRelationalDatabase
          extends Effect[
            StartRelationalDatabaseRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
          ]
      object CreateInstanceSnapshot
          extends Effect[
            CreateInstanceSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
          ]
      object UpdateDomainEntry
          extends Effect[
            UpdateDomainEntryRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
          ]
      object UpdateBucket
          extends Effect[
            UpdateBucketRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateBucketResponse.ReadOnly
          ]
      object RebootInstance
          extends Effect[
            RebootInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.RebootInstanceResponse.ReadOnly
          ]
      object CreateContactMethod
          extends Effect[
            CreateContactMethodRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateContactMethodResponse.ReadOnly
          ]
      object GetDiskSnapshots
          extends Effect[
            GetDiskSnapshotsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
          ]
      object CreateBucket
          extends Effect[
            CreateBucketRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly
          ]
      object GetContainerLog
          extends Effect[
            GetContainerLogRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly
          ]
      object GetContainerServiceDeployments
          extends Effect[
            GetContainerServiceDeploymentsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
          ]
      object CreateDomain
          extends Effect[
            CreateDomainRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateDomainResponse.ReadOnly
          ]
      object SetResourceAccessForBucket
          extends Effect[
            SetResourceAccessForBucketRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
          ]
      object GetBucketAccessKeys
          extends Effect[
            GetBucketAccessKeysRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
          ]
      object CreateContainerService
          extends Effect[
            CreateContainerServiceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly
          ]
      object IsVpcPeered
          extends Effect[
            IsVpcPeeredRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly
          ]
      object DeleteAutoSnapshot
          extends Effect[
            DeleteAutoSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
          ]
      object CreateContainerServiceRegistryLogin
          extends Effect[
            CreateContainerServiceRegistryLoginRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
          ]
      object GetDisk
          extends Effect[
            GetDiskRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly
          ]
      object EnableAddOn
          extends Effect[
            EnableAddOnRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.EnableAddOnResponse.ReadOnly
          ]
      object UntagResource
          extends Effect[
            UntagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly
          ]
      object CreateLoadBalancerTlsCertificate
          extends Effect[
            CreateLoadBalancerTlsCertificateRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
          ]
      object GetStaticIp
          extends Effect[
            GetStaticIpRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly
          ]
      object AttachStaticIp
          extends Effect[
            AttachStaticIpRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.AttachStaticIpResponse.ReadOnly
          ]
      object ImportKeyPair
          extends Effect[
            ImportKeyPairRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly
          ]
      object GetDisks
          extends Effect[
            GetDisksRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly
          ]
      object DownloadDefaultKeyPair
          extends Effect[
            DownloadDefaultKeyPairRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
          ]
      object GetExportSnapshotRecords
          extends Effect[
            GetExportSnapshotRecordsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
          ]
      object CreateKeyPair
          extends Effect[
            CreateKeyPairRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly
          ]
      object GetBundles
          extends Effect[
            GetBundlesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly
          ]
      object RegisterContainerImage
          extends Effect[
            RegisterContainerImageRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly
          ]
      object StartInstance
          extends Effect[
            StartInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.StartInstanceResponse.ReadOnly
          ]
      object GetInstancePortStates
          extends Effect[
            GetInstancePortStatesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
          ]
      object DeleteDisk
          extends Effect[
            DeleteDiskRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteDiskResponse.ReadOnly
          ]
      object GetBlueprints
          extends Effect[GetBlueprintsRequest, AwsError, ReadOnly]
      object DeleteAlarm
          extends Effect[
            DeleteAlarmRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteAlarmResponse.ReadOnly
          ]
      object CreateRelationalDatabaseSnapshot
          extends Effect[
            CreateRelationalDatabaseSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
          ]
      object GetContainerServiceMetricData
          extends Effect[
            GetContainerServiceMetricDataRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
          ]
      object GetRelationalDatabaseLogStreams
          extends Effect[
            GetRelationalDatabaseLogStreamsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
          ]
      object UpdateRelationalDatabaseParameters
          extends Effect[
            UpdateRelationalDatabaseParametersRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
          ]
      object CreateContainerServiceDeployment
          extends Effect[
            CreateContainerServiceDeploymentRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
          ]
      object GetDistributionLatestCacheReset
          extends Effect[
            GetDistributionLatestCacheResetRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
          ]
      object UpdateDistributionBundle
          extends Effect[
            UpdateDistributionBundleRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
          ]
      object DeleteKeyPair
          extends Effect[
            DeleteKeyPairRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairResponse.ReadOnly
          ]
      object UpdateBucketBundle
          extends Effect[
            UpdateBucketBundleRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
          ]
      object GetStaticIps
          extends Effect[
            GetStaticIpsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly
          ]
      object CreateRelationalDatabase
          extends Effect[
            CreateRelationalDatabaseRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
          ]
      object GetCertificates
          extends Effect[
            GetCertificatesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly
          ]
      object TagResource
          extends Effect[
            TagResourceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.TagResourceResponse.ReadOnly
          ]
      object DeleteDomain
          extends Effect[
            DeleteDomainRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteDomainResponse.ReadOnly
          ]
      object CreateBucketAccessKey
          extends Effect[
            CreateBucketAccessKeyRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
          ]
      object GetRelationalDatabaseSnapshots
          extends Effect[
            GetRelationalDatabaseSnapshotsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
          ]
      object CreateInstancesFromSnapshot
          extends Effect[
            CreateInstancesFromSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
          ]
      object ExportSnapshot
          extends Effect[
            ExportSnapshotRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.ExportSnapshotResponse.ReadOnly
          ]
      object AttachDisk
          extends Effect[
            AttachDiskRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.AttachDiskResponse.ReadOnly
          ]
      object SetIpAddressType
          extends Effect[
            SetIpAddressTypeRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
          ]
      object GetRegions
          extends Effect[
            GetRegionsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly
          ]
      object GetRelationalDatabaseMetricData
          extends Effect[
            GetRelationalDatabaseMetricDataRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
          ]
      object GetOperation
          extends Effect[
            GetOperationRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetOperationResponse.ReadOnly
          ]
      object StopInstance
          extends Effect[
            StopInstanceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.StopInstanceResponse.ReadOnly
          ]
      object GetDistributionMetricData
          extends Effect[
            GetDistributionMetricDataRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
          ]
      object GetKeyPairs
          extends Effect[
            GetKeyPairsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly
          ]
      object DisableAddOn
          extends Effect[
            DisableAddOnRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DisableAddOnResponse.ReadOnly
          ]
      object CreateInstances
          extends Effect[
            CreateInstancesRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateInstancesResponse.ReadOnly
          ]
      object CreateLoadBalancer
          extends Effect[
            CreateLoadBalancerRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
          ]
      object GetRelationalDatabaseBlueprints
          extends Effect[
            GetRelationalDatabaseBlueprintsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
          ]
      object DetachCertificateFromDistribution
          extends Effect[
            DetachCertificateFromDistributionRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
          ]
      object GetRelationalDatabaseMasterUserPassword
          extends Effect[
            GetRelationalDatabaseMasterUserPasswordRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
          ]
      object UpdateContainerService
          extends Effect[
            UpdateContainerServiceRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
          ]
      object GetContainerServicePowers
          extends Effect[
            GetContainerServicePowersRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
          ]
      object GetRelationalDatabase
          extends Effect[
            GetRelationalDatabaseRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
          ]
      object GetBuckets
          extends Effect[
            GetBucketsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly
          ]
      object GetCloudFormationStackRecords
          extends Effect[
            GetCloudFormationStackRecordsRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
          ]
      object UpdateDistribution
          extends Effect[
            UpdateDistributionRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly
          ]
      object DeleteDistribution
          extends Effect[
            DeleteDistributionRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteDistributionResponse.ReadOnly
          ]
      object DeleteContainerImage
          extends Effect[
            DeleteContainerImageRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageResponse.ReadOnly
          ]
      object CreateDistribution
          extends Effect[
            CreateDistributionRequest,
            AwsError,
            io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], Lightsail] = ZLayer.fromServiceM {
        proxy =>
          withRuntime.map { rts =>
            new Lightsail.Service {
              val api: LightsailAsyncClient = null
              def withAspect[R1](
                  newAspect: AwsCallAspect[R1],
                  r: R1
              ): Lightsail.Service = this
              def putInstancePublicPorts(
                  request: PutInstancePublicPortsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
              ] = proxy(PutInstancePublicPorts, request)
              def resetDistributionCache(
                  request: ResetDistributionCacheRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
              ] = proxy(ResetDistributionCache, request)
              def getRelationalDatabaseSnapshot(
                  request: GetRelationalDatabaseSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseSnapshot, request)
              def getKeyPair(request: GetKeyPairRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly
              ] = proxy(GetKeyPair, request)
              def getInstanceAccessDetails(
                  request: GetInstanceAccessDetailsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
              ] = proxy(GetInstanceAccessDetails, request)
              def deleteLoadBalancerTlsCertificate(
                  request: DeleteLoadBalancerTlsCertificateRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
              ] = proxy(DeleteLoadBalancerTlsCertificate, request)
              def createDiskSnapshot(request: CreateDiskSnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
              ] = proxy(CreateDiskSnapshot, request)
              def deleteRelationalDatabase(
                  request: DeleteRelationalDatabaseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
              ] = proxy(DeleteRelationalDatabase, request)
              def releaseStaticIp(request: ReleaseStaticIpRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
              ] = proxy(ReleaseStaticIp, request)
              def updateLoadBalancerAttribute(
                  request: UpdateLoadBalancerAttributeRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
              ] = proxy(UpdateLoadBalancerAttribute, request)
              def testAlarm(request: TestAlarmRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.TestAlarmResponse.ReadOnly
              ] = proxy(TestAlarm, request)
              def closeInstancePublicPorts(
                  request: CloseInstancePublicPortsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
              ] = proxy(CloseInstancePublicPorts, request)
              def deleteContactMethod(request: DeleteContactMethodRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodResponse.ReadOnly
              ] = proxy(DeleteContactMethod, request)
              def deleteDiskSnapshot(request: DeleteDiskSnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
              ] = proxy(DeleteDiskSnapshot, request)
              def putAlarm(request: PutAlarmRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.PutAlarmResponse.ReadOnly
              ] = proxy(PutAlarm, request)
              def getInstances(request: GetInstancesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly
              ] = proxy(GetInstances, request)
              def createCertificate(request: CreateCertificateRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly
              ] = proxy(CreateCertificate, request)
              def getRelationalDatabaseLogEvents(
                  request: GetRelationalDatabaseLogEventsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseLogEvents, request)
              def deleteKnownHostKeys(request: DeleteKnownHostKeysRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
              ] = proxy(DeleteKnownHostKeys, request)
              def rebootRelationalDatabase(
                  request: RebootRelationalDatabaseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
              ] = proxy(RebootRelationalDatabase, request)
              def createCloudFormationStack(
                  request: CreateCloudFormationStackRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
              ] = proxy(CreateCloudFormationStack, request)
              def getBucketMetricData(request: GetBucketMetricDataRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
              ] = proxy(GetBucketMetricData, request)
              def detachDisk(request: DetachDiskRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DetachDiskResponse.ReadOnly
              ] = proxy(DetachDisk, request)
              def allocateStaticIp(request: AllocateStaticIpRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpResponse.ReadOnly
              ] = proxy(AllocateStaticIp, request)
              def getRelationalDatabaseEvents(
                  request: GetRelationalDatabaseEventsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseEvents, request)
              def getOperations(request: GetOperationsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetOperationsResponse.ReadOnly
              ] = proxy(GetOperations, request)
              def getInstanceState(request: GetInstanceStateRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly
              ] = proxy(GetInstanceState, request)
              def getDomains(request: GetDomainsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly
              ] = proxy(GetDomains, request)
              def getLoadBalancers(request: GetLoadBalancersRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly
              ] = proxy(GetLoadBalancers, request)
              def getContainerServices(
                  request: GetContainerServicesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly
              ] = proxy(GetContainerServices, request)
              def getLoadBalancerTlsCertificates(
                  request: GetLoadBalancerTlsCertificatesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
              ] = proxy(GetLoadBalancerTlsCertificates, request)
              def createRelationalDatabaseFromSnapshot(
                  request: CreateRelationalDatabaseFromSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
              ] = proxy(CreateRelationalDatabaseFromSnapshot, request)
              def getInstanceSnapshot(request: GetInstanceSnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
              ] = proxy(GetInstanceSnapshot, request)
              def deleteContainerService(
                  request: DeleteContainerServiceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
              ] = proxy(DeleteContainerService, request)
              def getContainerAPIMetadata(
                  request: GetContainerApiMetadataRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
              ] = proxy(GetContainerAPIMetadata, request)
              def getDiskSnapshot(request: GetDiskSnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
              ] = proxy(GetDiskSnapshot, request)
              def detachStaticIp(request: DetachStaticIpRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DetachStaticIpResponse.ReadOnly
              ] = proxy(DetachStaticIp, request)
              def createDisk(request: CreateDiskRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateDiskResponse.ReadOnly
              ] = proxy(CreateDisk, request)
              def getContainerImages(request: GetContainerImagesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly
              ] = proxy(GetContainerImages, request)
              def deleteBucketAccessKey(
                  request: DeleteBucketAccessKeyRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
              ] = proxy(DeleteBucketAccessKey, request)
              def createDomainEntry(request: CreateDomainEntryRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly
              ] = proxy(CreateDomainEntry, request)
              def sendContactMethodVerification(
                  request: SendContactMethodVerificationRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
              ] = proxy(SendContactMethodVerification, request)
              def getDomain(request: GetDomainRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly
              ] = proxy(GetDomain, request)
              def deleteInstance(request: DeleteInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteInstanceResponse.ReadOnly
              ] = proxy(DeleteInstance, request)
              def copySnapshot(request: CopySnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CopySnapshotResponse.ReadOnly
              ] = proxy(CopySnapshot, request)
              def getContactMethods(request: GetContactMethodsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly
              ] = proxy(GetContactMethods, request)
              def getRelationalDatabaseBundles(
                  request: GetRelationalDatabaseBundlesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseBundles, request)
              def detachInstancesFromLoadBalancer(
                  request: DetachInstancesFromLoadBalancerRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
              ] = proxy(DetachInstancesFromLoadBalancer, request)
              def openInstancePublicPorts(
                  request: OpenInstancePublicPortsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
              ] = proxy(OpenInstancePublicPorts, request)
              def getInstanceMetricData(
                  request: GetInstanceMetricDataRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
              ] = proxy(GetInstanceMetricData, request)
              def deleteRelationalDatabaseSnapshot(
                  request: DeleteRelationalDatabaseSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
              ] = proxy(DeleteRelationalDatabaseSnapshot, request)
              def attachInstancesToLoadBalancer(
                  request: AttachInstancesToLoadBalancerRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
              ] = proxy(AttachInstancesToLoadBalancer, request)
              def getDistributionBundles(
                  request: GetDistributionBundlesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
              ] = proxy(GetDistributionBundles, request)
              def getRelationalDatabaseParameters(
                  request: GetRelationalDatabaseParametersRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseParameters, request)
              def getAlarms(request: GetAlarmsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly
              ] = proxy(GetAlarms, request)
              def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
              ] = proxy(DeleteLoadBalancer, request)
              def getInstanceSnapshots(
                  request: GetInstanceSnapshotsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
              ] = proxy(GetInstanceSnapshots, request)
              def stopRelationalDatabase(
                  request: StopRelationalDatabaseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
              ] = proxy(StopRelationalDatabase, request)
              def getLoadBalancerMetricData(
                  request: GetLoadBalancerMetricDataRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
              ] = proxy(GetLoadBalancerMetricData, request)
              def attachCertificateToDistribution(
                  request: AttachCertificateToDistributionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
              ] = proxy(AttachCertificateToDistribution, request)
              def deleteCertificate(request: DeleteCertificateRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteCertificateResponse.ReadOnly
              ] = proxy(DeleteCertificate, request)
              def getInstance(request: GetInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly
              ] = proxy(GetInstance, request)
              def getDistributions(request: GetDistributionsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly
              ] = proxy(GetDistributions, request)
              def getRelationalDatabases(
                  request: GetRelationalDatabasesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
              ] = proxy(GetRelationalDatabases, request)
              def attachLoadBalancerTlsCertificate(
                  request: AttachLoadBalancerTlsCertificateRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
              ] = proxy(AttachLoadBalancerTlsCertificate, request)
              def getOperationsForResource(
                  request: GetOperationsForResourceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
              ] = proxy(GetOperationsForResource, request)
              def createDiskFromSnapshot(
                  request: CreateDiskFromSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
              ] = proxy(CreateDiskFromSnapshot, request)
              def getLoadBalancer(request: GetLoadBalancerRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly
              ] = proxy(GetLoadBalancer, request)
              def getBucketBundles(request: GetBucketBundlesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly
              ] = proxy(GetBucketBundles, request)
              def deleteInstanceSnapshot(
                  request: DeleteInstanceSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
              ] = proxy(DeleteInstanceSnapshot, request)
              def deleteDomainEntry(request: DeleteDomainEntryRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
              ] = proxy(DeleteDomainEntry, request)
              def updateRelationalDatabase(
                  request: UpdateRelationalDatabaseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
              ] = proxy(UpdateRelationalDatabase, request)
              def peerVpc(request: PeerVpcRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.PeerVpcResponse.ReadOnly
              ] = proxy(PeerVpc, request)
              def unpeerVpc(request: UnpeerVpcRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UnpeerVpcResponse.ReadOnly
              ] = proxy(UnpeerVpc, request)
              def getActiveNames(request: GetActiveNamesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly
              ] = proxy(GetActiveNames, request)
              def deleteBucket(request: DeleteBucketRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteBucketResponse.ReadOnly
              ] = proxy(DeleteBucket, request)
              def getAutoSnapshots(request: GetAutoSnapshotsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
              ] = proxy(GetAutoSnapshots, request)
              def startRelationalDatabase(
                  request: StartRelationalDatabaseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
              ] = proxy(StartRelationalDatabase, request)
              def createInstanceSnapshot(
                  request: CreateInstanceSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
              ] = proxy(CreateInstanceSnapshot, request)
              def updateDomainEntry(request: UpdateDomainEntryRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
              ] = proxy(UpdateDomainEntry, request)
              def updateBucket(request: UpdateBucketRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateBucketResponse.ReadOnly
              ] = proxy(UpdateBucket, request)
              def rebootInstance(request: RebootInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.RebootInstanceResponse.ReadOnly
              ] = proxy(RebootInstance, request)
              def createContactMethod(request: CreateContactMethodRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateContactMethodResponse.ReadOnly
              ] = proxy(CreateContactMethod, request)
              def getDiskSnapshots(request: GetDiskSnapshotsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
              ] = proxy(GetDiskSnapshots, request)
              def createBucket(request: CreateBucketRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly
              ] = proxy(CreateBucket, request)
              def getContainerLog(request: GetContainerLogRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly
              ] = proxy(GetContainerLog, request)
              def getContainerServiceDeployments(
                  request: GetContainerServiceDeploymentsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
              ] = proxy(GetContainerServiceDeployments, request)
              def createDomain(request: CreateDomainRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateDomainResponse.ReadOnly
              ] = proxy(CreateDomain, request)
              def setResourceAccessForBucket(
                  request: SetResourceAccessForBucketRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
              ] = proxy(SetResourceAccessForBucket, request)
              def getBucketAccessKeys(request: GetBucketAccessKeysRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
              ] = proxy(GetBucketAccessKeys, request)
              def createContainerService(
                  request: CreateContainerServiceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly
              ] = proxy(CreateContainerService, request)
              def isVpcPeered(request: IsVpcPeeredRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly
              ] = proxy(IsVpcPeered, request)
              def deleteAutoSnapshot(request: DeleteAutoSnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
              ] = proxy(DeleteAutoSnapshot, request)
              def createContainerServiceRegistryLogin(
                  request: CreateContainerServiceRegistryLoginRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
              ] = proxy(CreateContainerServiceRegistryLogin, request)
              def getDisk(request: GetDiskRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly
              ] = proxy(GetDisk, request)
              def enableAddOn(request: EnableAddOnRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.EnableAddOnResponse.ReadOnly
              ] = proxy(EnableAddOn, request)
              def untagResource(request: UntagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly
              ] = proxy(UntagResource, request)
              def createLoadBalancerTlsCertificate(
                  request: CreateLoadBalancerTlsCertificateRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
              ] = proxy(CreateLoadBalancerTlsCertificate, request)
              def getStaticIp(request: GetStaticIpRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly
              ] = proxy(GetStaticIp, request)
              def attachStaticIp(request: AttachStaticIpRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.AttachStaticIpResponse.ReadOnly
              ] = proxy(AttachStaticIp, request)
              def importKeyPair(request: ImportKeyPairRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly
              ] = proxy(ImportKeyPair, request)
              def getDisks(request: GetDisksRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly
              ] = proxy(GetDisks, request)
              def downloadDefaultKeyPair(
                  request: DownloadDefaultKeyPairRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
              ] = proxy(DownloadDefaultKeyPair, request)
              def getExportSnapshotRecords(
                  request: GetExportSnapshotRecordsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
              ] = proxy(GetExportSnapshotRecords, request)
              def createKeyPair(request: CreateKeyPairRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly
              ] = proxy(CreateKeyPair, request)
              def getBundles(request: GetBundlesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly
              ] = proxy(GetBundles, request)
              def registerContainerImage(
                  request: RegisterContainerImageRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly
              ] = proxy(RegisterContainerImage, request)
              def startInstance(request: StartInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.StartInstanceResponse.ReadOnly
              ] = proxy(StartInstance, request)
              def getInstancePortStates(
                  request: GetInstancePortStatesRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
              ] = proxy(GetInstancePortStates, request)
              def deleteDisk(request: DeleteDiskRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteDiskResponse.ReadOnly
              ] = proxy(DeleteDisk, request)
              def getBlueprints(
                  request: GetBlueprintsRequest
              ): IO[AwsError, ReadOnly] = proxy(GetBlueprints, request)
              def deleteAlarm(request: DeleteAlarmRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteAlarmResponse.ReadOnly
              ] = proxy(DeleteAlarm, request)
              def createRelationalDatabaseSnapshot(
                  request: CreateRelationalDatabaseSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
              ] = proxy(CreateRelationalDatabaseSnapshot, request)
              def getContainerServiceMetricData(
                  request: GetContainerServiceMetricDataRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
              ] = proxy(GetContainerServiceMetricData, request)
              def getRelationalDatabaseLogStreams(
                  request: GetRelationalDatabaseLogStreamsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseLogStreams, request)
              def updateRelationalDatabaseParameters(
                  request: UpdateRelationalDatabaseParametersRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
              ] = proxy(UpdateRelationalDatabaseParameters, request)
              def createContainerServiceDeployment(
                  request: CreateContainerServiceDeploymentRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
              ] = proxy(CreateContainerServiceDeployment, request)
              def getDistributionLatestCacheReset(
                  request: GetDistributionLatestCacheResetRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
              ] = proxy(GetDistributionLatestCacheReset, request)
              def updateDistributionBundle(
                  request: UpdateDistributionBundleRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
              ] = proxy(UpdateDistributionBundle, request)
              def deleteKeyPair(request: DeleteKeyPairRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairResponse.ReadOnly
              ] = proxy(DeleteKeyPair, request)
              def updateBucketBundle(request: UpdateBucketBundleRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
              ] = proxy(UpdateBucketBundle, request)
              def getStaticIps(request: GetStaticIpsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly
              ] = proxy(GetStaticIps, request)
              def createRelationalDatabase(
                  request: CreateRelationalDatabaseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
              ] = proxy(CreateRelationalDatabase, request)
              def getCertificates(request: GetCertificatesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly
              ] = proxy(GetCertificates, request)
              def tagResource(request: TagResourceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.TagResourceResponse.ReadOnly
              ] = proxy(TagResource, request)
              def deleteDomain(request: DeleteDomainRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteDomainResponse.ReadOnly
              ] = proxy(DeleteDomain, request)
              def createBucketAccessKey(
                  request: CreateBucketAccessKeyRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
              ] = proxy(CreateBucketAccessKey, request)
              def getRelationalDatabaseSnapshots(
                  request: GetRelationalDatabaseSnapshotsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseSnapshots, request)
              def createInstancesFromSnapshot(
                  request: CreateInstancesFromSnapshotRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
              ] = proxy(CreateInstancesFromSnapshot, request)
              def exportSnapshot(request: ExportSnapshotRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.ExportSnapshotResponse.ReadOnly
              ] = proxy(ExportSnapshot, request)
              def attachDisk(request: AttachDiskRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.AttachDiskResponse.ReadOnly
              ] = proxy(AttachDisk, request)
              def setIpAddressType(request: SetIpAddressTypeRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
              ] = proxy(SetIpAddressType, request)
              def getRegions(request: GetRegionsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly
              ] = proxy(GetRegions, request)
              def getRelationalDatabaseMetricData(
                  request: GetRelationalDatabaseMetricDataRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseMetricData, request)
              def getOperation(request: GetOperationRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetOperationResponse.ReadOnly
              ] = proxy(GetOperation, request)
              def stopInstance(request: StopInstanceRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.StopInstanceResponse.ReadOnly
              ] = proxy(StopInstance, request)
              def getDistributionMetricData(
                  request: GetDistributionMetricDataRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
              ] = proxy(GetDistributionMetricData, request)
              def getKeyPairs(request: GetKeyPairsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly
              ] = proxy(GetKeyPairs, request)
              def disableAddOn(request: DisableAddOnRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DisableAddOnResponse.ReadOnly
              ] = proxy(DisableAddOn, request)
              def createInstances(request: CreateInstancesRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateInstancesResponse.ReadOnly
              ] = proxy(CreateInstances, request)
              def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
              ] = proxy(CreateLoadBalancer, request)
              def getRelationalDatabaseBlueprints(
                  request: GetRelationalDatabaseBlueprintsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseBlueprints, request)
              def detachCertificateFromDistribution(
                  request: DetachCertificateFromDistributionRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
              ] = proxy(DetachCertificateFromDistribution, request)
              def getRelationalDatabaseMasterUserPassword(
                  request: GetRelationalDatabaseMasterUserPasswordRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
              ] = proxy(GetRelationalDatabaseMasterUserPassword, request)
              def updateContainerService(
                  request: UpdateContainerServiceRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
              ] = proxy(UpdateContainerService, request)
              def getContainerServicePowers(
                  request: GetContainerServicePowersRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
              ] = proxy(GetContainerServicePowers, request)
              def getRelationalDatabase(
                  request: GetRelationalDatabaseRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
              ] = proxy(GetRelationalDatabase, request)
              def getBuckets(request: GetBucketsRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly
              ] = proxy(GetBuckets, request)
              def getCloudFormationStackRecords(
                  request: GetCloudFormationStackRecordsRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
              ] = proxy(GetCloudFormationStackRecords, request)
              def updateDistribution(request: UpdateDistributionRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly
              ] = proxy(UpdateDistribution, request)
              def deleteDistribution(request: DeleteDistributionRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteDistributionResponse.ReadOnly
              ] = proxy(DeleteDistribution, request)
              def deleteContainerImage(
                  request: DeleteContainerImageRequest
              ): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageResponse.ReadOnly
              ] = proxy(DeleteContainerImage, request)
              def createDistribution(request: CreateDistributionRequest): IO[
                AwsError,
                io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly
              ] = proxy(CreateDistribution, request)
            }
          }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, Lightsail] = customized(
    identity
  )
  def customized(
      customization: LightsailAsyncClientBuilder => LightsailAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Lightsail] = managed(
    customization
  ).toLayer
  def managed(
      customization: LightsailAsyncClientBuilder => LightsailAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Lightsail.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = LightsailAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LightsailAsyncClient, LightsailAsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[LightsailAsyncClient, LightsailAsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  )
    yield new LightsailImpl(
      client,
      AwsCallAspect.identity,
      ().asInstanceOf[Any]
    )
  private class LightsailImpl[R](
      override val api: LightsailAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends Lightsail.Service
      with AwsServiceBase[R, LightsailImpl] {
    override val serviceName: String = "Lightsail"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): LightsailImpl[R1] = new LightsailImpl(api, newAspect, r)
    def putInstancePublicPorts(request: PutInstancePublicPortsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest,
      PutInstancePublicPortsResponse
    ]("putInstancePublicPorts", api.putInstancePublicPorts)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsResponse.wrap
    ).provide(r)
    def resetDistributionCache(request: ResetDistributionCacheRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest,
      ResetDistributionCacheResponse
    ]("resetDistributionCache", api.resetDistributionCache)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.wrap
    ).provide(r)
    def getRelationalDatabaseSnapshot(
        request: GetRelationalDatabaseSnapshotRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest,
      GetRelationalDatabaseSnapshotResponse
    ]("getRelationalDatabaseSnapshot", api.getRelationalDatabaseSnapshot)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.wrap
    ).provide(r)
    def getKeyPair(request: GetKeyPairRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest,
      GetKeyPairResponse
    ]("getKeyPair", api.getKeyPair)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.wrap)
      .provide(r)
    def getInstanceAccessDetails(request: GetInstanceAccessDetailsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest,
      GetInstanceAccessDetailsResponse
    ]("getInstanceAccessDetails", api.getInstanceAccessDetails)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.wrap
    ).provide(r)
    def deleteLoadBalancerTlsCertificate(
        request: DeleteLoadBalancerTlsCertificateRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest,
      DeleteLoadBalancerTlsCertificateResponse
    ]("deleteLoadBalancerTlsCertificate", api.deleteLoadBalancerTlsCertificate)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.wrap
    ).provide(r)
    def createDiskSnapshot(request: CreateDiskSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest,
      CreateDiskSnapshotResponse
    ]("createDiskSnapshot", api.createDiskSnapshot)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotResponse.wrap
      )
      .provide(r)
    def deleteRelationalDatabase(request: DeleteRelationalDatabaseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest,
      DeleteRelationalDatabaseResponse
    ]("deleteRelationalDatabase", api.deleteRelationalDatabase)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseResponse.wrap
    ).provide(r)
    def releaseStaticIp(request: ReleaseStaticIpRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest,
      ReleaseStaticIpResponse
    ]("releaseStaticIp", api.releaseStaticIp)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpResponse.wrap)
      .provide(r)
    def updateLoadBalancerAttribute(
        request: UpdateLoadBalancerAttributeRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest,
      UpdateLoadBalancerAttributeResponse
    ]("updateLoadBalancerAttribute", api.updateLoadBalancerAttribute)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeResponse.wrap
    ).provide(r)
    def testAlarm(request: TestAlarmRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.TestAlarmResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.TestAlarmRequest,
      TestAlarmResponse
    ]("testAlarm", api.testAlarm)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.TestAlarmResponse.wrap)
      .provide(r)
    def closeInstancePublicPorts(request: CloseInstancePublicPortsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest,
      CloseInstancePublicPortsResponse
    ]("closeInstancePublicPorts", api.closeInstancePublicPorts)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsResponse.wrap
    ).provide(r)
    def deleteContactMethod(request: DeleteContactMethodRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest,
      DeleteContactMethodResponse
    ]("deleteContactMethod", api.deleteContactMethod)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodResponse.wrap
      )
      .provide(r)
    def deleteDiskSnapshot(request: DeleteDiskSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest,
      DeleteDiskSnapshotResponse
    ]("deleteDiskSnapshot", api.deleteDiskSnapshot)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotResponse.wrap
      )
      .provide(r)
    def putAlarm(request: PutAlarmRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.PutAlarmResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.PutAlarmRequest,
      PutAlarmResponse
    ]("putAlarm", api.putAlarm)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.PutAlarmResponse.wrap)
      .provide(r)
    def getInstances(request: GetInstancesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstancesRequest,
      GetInstancesResponse
    ]("getInstances", api.getInstances)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.wrap)
      .provide(r)
    def createCertificate(request: CreateCertificateRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest,
      CreateCertificateResponse
    ]("createCertificate", api.createCertificate)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.wrap
      )
      .provide(r)
    def getRelationalDatabaseLogEvents(
        request: GetRelationalDatabaseLogEventsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest,
      GetRelationalDatabaseLogEventsResponse
    ]("getRelationalDatabaseLogEvents", api.getRelationalDatabaseLogEvents)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.wrap
    ).provide(r)
    def deleteKnownHostKeys(request: DeleteKnownHostKeysRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest,
      DeleteKnownHostKeysResponse
    ]("deleteKnownHostKeys", api.deleteKnownHostKeys)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysResponse.wrap
      )
      .provide(r)
    def rebootRelationalDatabase(request: RebootRelationalDatabaseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest,
      RebootRelationalDatabaseResponse
    ]("rebootRelationalDatabase", api.rebootRelationalDatabase)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseResponse.wrap
    ).provide(r)
    def createCloudFormationStack(
        request: CreateCloudFormationStackRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest,
      CreateCloudFormationStackResponse
    ]("createCloudFormationStack", api.createCloudFormationStack)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackResponse.wrap
    ).provide(r)
    def getBucketMetricData(request: GetBucketMetricDataRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest,
      GetBucketMetricDataResponse
    ]("getBucketMetricData", api.getBucketMetricData)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataResponse.wrap
      )
      .provide(r)
    def detachDisk(request: DetachDiskRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DetachDiskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DetachDiskRequest,
      DetachDiskResponse
    ]("detachDisk", api.detachDisk)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DetachDiskResponse.wrap)
      .provide(r)
    def allocateStaticIp(request: AllocateStaticIpRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest,
      AllocateStaticIpResponse
    ]("allocateStaticIp", api.allocateStaticIp)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpResponse.wrap)
      .provide(r)
    def getRelationalDatabaseEvents(
        request: GetRelationalDatabaseEventsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest,
      GetRelationalDatabaseEventsResponse
    ]("getRelationalDatabaseEvents", api.getRelationalDatabaseEvents)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.wrap
    ).provide(r)
    def getOperations(request: GetOperationsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetOperationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetOperationsRequest,
      GetOperationsResponse
    ]("getOperations", api.getOperations)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetOperationsResponse.wrap)
      .provide(r)
    def getInstanceState(request: GetInstanceStateRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest,
      GetInstanceStateResponse
    ]("getInstanceState", api.getInstanceState)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.wrap)
      .provide(r)
    def getDomains(request: GetDomainsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDomainsRequest,
      GetDomainsResponse
    ]("getDomains", api.getDomains)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.wrap)
      .provide(r)
    def getLoadBalancers(request: GetLoadBalancersRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest,
      GetLoadBalancersResponse
    ]("getLoadBalancers", api.getLoadBalancers)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.wrap)
      .provide(r)
    def getContainerServices(request: GetContainerServicesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest,
      GetContainerServicesResponse
    ]("getContainerServices", api.getContainerServices)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.wrap
      )
      .provide(r)
    def getLoadBalancerTlsCertificates(
        request: GetLoadBalancerTlsCertificatesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest,
      GetLoadBalancerTlsCertificatesResponse
    ]("getLoadBalancerTlsCertificates", api.getLoadBalancerTlsCertificates)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.wrap
    ).provide(r)
    def createRelationalDatabaseFromSnapshot(
        request: CreateRelationalDatabaseFromSnapshotRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest,
      CreateRelationalDatabaseFromSnapshotResponse
    ](
      "createRelationalDatabaseFromSnapshot",
      api.createRelationalDatabaseFromSnapshot
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.wrap
      )
      .provide(r)
    def getInstanceSnapshot(request: GetInstanceSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest,
      GetInstanceSnapshotResponse
    ]("getInstanceSnapshot", api.getInstanceSnapshot)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.wrap
      )
      .provide(r)
    def deleteContainerService(request: DeleteContainerServiceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest,
      DeleteContainerServiceResponse
    ]("deleteContainerService", api.deleteContainerService)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceResponse.wrap
    ).provide(r)
    def getContainerAPIMetadata(request: GetContainerApiMetadataRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest,
      GetContainerApiMetadataResponse
    ]("getContainerAPIMetadata", api.getContainerAPIMetadata)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.wrap
    ).provide(r)
    def getDiskSnapshot(request: GetDiskSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest,
      GetDiskSnapshotResponse
    ]("getDiskSnapshot", api.getDiskSnapshot)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.wrap)
      .provide(r)
    def detachStaticIp(request: DetachStaticIpRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DetachStaticIpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest,
      DetachStaticIpResponse
    ]("detachStaticIp", api.detachStaticIp)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DetachStaticIpResponse.wrap)
      .provide(r)
    def createDisk(request: CreateDiskRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateDiskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDiskRequest,
      CreateDiskResponse
    ]("createDisk", api.createDisk)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.CreateDiskResponse.wrap)
      .provide(r)
    def getContainerImages(request: GetContainerImagesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest,
      GetContainerImagesResponse
    ]("getContainerImages", api.getContainerImages)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.wrap
      )
      .provide(r)
    def deleteBucketAccessKey(request: DeleteBucketAccessKeyRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest,
      DeleteBucketAccessKeyResponse
    ]("deleteBucketAccessKey", api.deleteBucketAccessKey)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyResponse.wrap
    ).provide(r)
    def createDomainEntry(request: CreateDomainEntryRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest,
      CreateDomainEntryResponse
    ]("createDomainEntry", api.createDomainEntry)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.wrap
      )
      .provide(r)
    def sendContactMethodVerification(
        request: SendContactMethodVerificationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest,
      SendContactMethodVerificationResponse
    ]("sendContactMethodVerification", api.sendContactMethodVerification)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationResponse.wrap
    ).provide(r)
    def getDomain(request: GetDomainRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDomainRequest,
      GetDomainResponse
    ]("getDomain", api.getDomain)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.wrap)
      .provide(r)
    def deleteInstance(request: DeleteInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest,
      DeleteInstanceResponse
    ]("deleteInstance", api.deleteInstance)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DeleteInstanceResponse.wrap)
      .provide(r)
    def copySnapshot(request: CopySnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CopySnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest,
      CopySnapshotResponse
    ]("copySnapshot", api.copySnapshot)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.CopySnapshotResponse.wrap)
      .provide(r)
    def getContactMethods(request: GetContactMethodsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest,
      GetContactMethodsResponse
    ]("getContactMethods", api.getContactMethods)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.wrap
      )
      .provide(r)
    def getRelationalDatabaseBundles(
        request: GetRelationalDatabaseBundlesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest,
      GetRelationalDatabaseBundlesResponse
    ]("getRelationalDatabaseBundles", api.getRelationalDatabaseBundles)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.wrap
    ).provide(r)
    def detachInstancesFromLoadBalancer(
        request: DetachInstancesFromLoadBalancerRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest,
      DetachInstancesFromLoadBalancerResponse
    ]("detachInstancesFromLoadBalancer", api.detachInstancesFromLoadBalancer)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DetachInstancesFromLoadBalancerResponse.wrap
    ).provide(r)
    def openInstancePublicPorts(request: OpenInstancePublicPortsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest,
      OpenInstancePublicPortsResponse
    ]("openInstancePublicPorts", api.openInstancePublicPorts)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsResponse.wrap
    ).provide(r)
    def getInstanceMetricData(request: GetInstanceMetricDataRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest,
      GetInstanceMetricDataResponse
    ]("getInstanceMetricData", api.getInstanceMetricData)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataResponse.wrap
    ).provide(r)
    def deleteRelationalDatabaseSnapshot(
        request: DeleteRelationalDatabaseSnapshotRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest,
      DeleteRelationalDatabaseSnapshotResponse
    ]("deleteRelationalDatabaseSnapshot", api.deleteRelationalDatabaseSnapshot)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.wrap
    ).provide(r)
    def attachInstancesToLoadBalancer(
        request: AttachInstancesToLoadBalancerRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest,
      AttachInstancesToLoadBalancerResponse
    ]("attachInstancesToLoadBalancer", api.attachInstancesToLoadBalancer)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerResponse.wrap
    ).provide(r)
    def getDistributionBundles(request: GetDistributionBundlesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest,
      GetDistributionBundlesResponse
    ]("getDistributionBundles", api.getDistributionBundles)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.wrap
    ).provide(r)
    def getRelationalDatabaseParameters(
        request: GetRelationalDatabaseParametersRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest,
      GetRelationalDatabaseParametersResponse
    ]("getRelationalDatabaseParameters", api.getRelationalDatabaseParameters)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.wrap
    ).provide(r)
    def getAlarms(request: GetAlarmsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest,
      GetAlarmsResponse
    ]("getAlarms", api.getAlarms)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.wrap)
      .provide(r)
    def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest,
      DeleteLoadBalancerResponse
    ]("deleteLoadBalancer", api.deleteLoadBalancer)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerResponse.wrap
      )
      .provide(r)
    def getInstanceSnapshots(request: GetInstanceSnapshotsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest,
      GetInstanceSnapshotsResponse
    ]("getInstanceSnapshots", api.getInstanceSnapshots)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.wrap
      )
      .provide(r)
    def stopRelationalDatabase(request: StopRelationalDatabaseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest,
      StopRelationalDatabaseResponse
    ]("stopRelationalDatabase", api.stopRelationalDatabase)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseResponse.wrap
    ).provide(r)
    def getLoadBalancerMetricData(
        request: GetLoadBalancerMetricDataRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest,
      GetLoadBalancerMetricDataResponse
    ]("getLoadBalancerMetricData", api.getLoadBalancerMetricData)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.wrap
    ).provide(r)
    def attachCertificateToDistribution(
        request: AttachCertificateToDistributionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest,
      AttachCertificateToDistributionResponse
    ]("attachCertificateToDistribution", api.attachCertificateToDistribution)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionResponse.wrap
    ).provide(r)
    def deleteCertificate(request: DeleteCertificateRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest,
      DeleteCertificateResponse
    ]("deleteCertificate", api.deleteCertificate)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteCertificateResponse.wrap
      )
      .provide(r)
    def getInstance(request: GetInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceRequest,
      GetInstanceResponse
    ]("getInstance", api.getInstance)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.wrap)
      .provide(r)
    def getDistributions(request: GetDistributionsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest,
      GetDistributionsResponse
    ]("getDistributions", api.getDistributions)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.wrap)
      .provide(r)
    def getRelationalDatabases(request: GetRelationalDatabasesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest,
      GetRelationalDatabasesResponse
    ]("getRelationalDatabases", api.getRelationalDatabases)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.wrap
    ).provide(r)
    def attachLoadBalancerTlsCertificate(
        request: AttachLoadBalancerTlsCertificateRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest,
      AttachLoadBalancerTlsCertificateResponse
    ]("attachLoadBalancerTlsCertificate", api.attachLoadBalancerTlsCertificate)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.wrap
    ).provide(r)
    def getOperationsForResource(request: GetOperationsForResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest,
      GetOperationsForResourceResponse
    ]("getOperationsForResource", api.getOperationsForResource)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.wrap
    ).provide(r)
    def createDiskFromSnapshot(request: CreateDiskFromSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest,
      CreateDiskFromSnapshotResponse
    ]("createDiskFromSnapshot", api.createDiskFromSnapshot)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotResponse.wrap
    ).provide(r)
    def getLoadBalancer(request: GetLoadBalancerRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest,
      GetLoadBalancerResponse
    ]("getLoadBalancer", api.getLoadBalancer)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.wrap)
      .provide(r)
    def getBucketBundles(request: GetBucketBundlesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest,
      GetBucketBundlesResponse
    ]("getBucketBundles", api.getBucketBundles)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.wrap)
      .provide(r)
    def deleteInstanceSnapshot(request: DeleteInstanceSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest,
      DeleteInstanceSnapshotResponse
    ]("deleteInstanceSnapshot", api.deleteInstanceSnapshot)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotResponse.wrap
    ).provide(r)
    def deleteDomainEntry(request: DeleteDomainEntryRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest,
      DeleteDomainEntryResponse
    ]("deleteDomainEntry", api.deleteDomainEntry)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryResponse.wrap
      )
      .provide(r)
    def updateRelationalDatabase(request: UpdateRelationalDatabaseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest,
      UpdateRelationalDatabaseResponse
    ]("updateRelationalDatabase", api.updateRelationalDatabase)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseResponse.wrap
    ).provide(r)
    def peerVpc(request: PeerVpcRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.PeerVpcResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.PeerVpcRequest,
      PeerVpcResponse
    ]("peerVpc", api.peerVpc)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.PeerVpcResponse.wrap)
      .provide(r)
    def unpeerVpc(request: UnpeerVpcRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UnpeerVpcResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest,
      UnpeerVpcResponse
    ]("unpeerVpc", api.unpeerVpc)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.UnpeerVpcResponse.wrap)
      .provide(r)
    def getActiveNames(request: GetActiveNamesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest,
      GetActiveNamesResponse
    ]("getActiveNames", api.getActiveNames)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.wrap)
      .provide(r)
    def deleteBucket(request: DeleteBucketRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteBucketResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest,
      DeleteBucketResponse
    ]("deleteBucket", api.deleteBucket)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DeleteBucketResponse.wrap)
      .provide(r)
    def getAutoSnapshots(request: GetAutoSnapshotsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest,
      GetAutoSnapshotsResponse
    ]("getAutoSnapshots", api.getAutoSnapshots)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.wrap)
      .provide(r)
    def startRelationalDatabase(request: StartRelationalDatabaseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest,
      StartRelationalDatabaseResponse
    ]("startRelationalDatabase", api.startRelationalDatabase)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseResponse.wrap
    ).provide(r)
    def createInstanceSnapshot(request: CreateInstanceSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest,
      CreateInstanceSnapshotResponse
    ]("createInstanceSnapshot", api.createInstanceSnapshot)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotResponse.wrap
    ).provide(r)
    def updateDomainEntry(request: UpdateDomainEntryRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest,
      UpdateDomainEntryResponse
    ]("updateDomainEntry", api.updateDomainEntry)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryResponse.wrap
      )
      .provide(r)
    def updateBucket(request: UpdateBucketRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateBucketResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest,
      UpdateBucketResponse
    ]("updateBucket", api.updateBucket)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.UpdateBucketResponse.wrap)
      .provide(r)
    def rebootInstance(request: RebootInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RebootInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest,
      RebootInstanceResponse
    ]("rebootInstance", api.rebootInstance)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.RebootInstanceResponse.wrap)
      .provide(r)
    def createContactMethod(request: CreateContactMethodRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateContactMethodResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest,
      CreateContactMethodResponse
    ]("createContactMethod", api.createContactMethod)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateContactMethodResponse.wrap
      )
      .provide(r)
    def getDiskSnapshots(request: GetDiskSnapshotsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest,
      GetDiskSnapshotsResponse
    ]("getDiskSnapshots", api.getDiskSnapshots)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.wrap)
      .provide(r)
    def createBucket(request: CreateBucketRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateBucketRequest,
      CreateBucketResponse
    ]("createBucket", api.createBucket)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.wrap)
      .provide(r)
    def getContainerLog(request: GetContainerLogRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest,
      GetContainerLogResponse
    ]("getContainerLog", api.getContainerLog)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.wrap)
      .provide(r)
    def getContainerServiceDeployments(
        request: GetContainerServiceDeploymentsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest,
      GetContainerServiceDeploymentsResponse
    ]("getContainerServiceDeployments", api.getContainerServiceDeployments)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.wrap
    ).provide(r)
    def createDomain(request: CreateDomainRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDomainRequest,
      CreateDomainResponse
    ]("createDomain", api.createDomain)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.CreateDomainResponse.wrap)
      .provide(r)
    def setResourceAccessForBucket(
        request: SetResourceAccessForBucketRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest,
      SetResourceAccessForBucketResponse
    ]("setResourceAccessForBucket", api.setResourceAccessForBucket)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketResponse.wrap
    ).provide(r)
    def getBucketAccessKeys(request: GetBucketAccessKeysRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest,
      GetBucketAccessKeysResponse
    ]("getBucketAccessKeys", api.getBucketAccessKeys)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.wrap
      )
      .provide(r)
    def createContainerService(request: CreateContainerServiceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest,
      CreateContainerServiceResponse
    ]("createContainerService", api.createContainerService)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.wrap
    ).provide(r)
    def isVpcPeered(request: IsVpcPeeredRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest,
      IsVpcPeeredResponse
    ]("isVpcPeered", api.isVpcPeered)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.wrap)
      .provide(r)
    def deleteAutoSnapshot(request: DeleteAutoSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest,
      DeleteAutoSnapshotResponse
    ]("deleteAutoSnapshot", api.deleteAutoSnapshot)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotResponse.wrap
      )
      .provide(r)
    def createContainerServiceRegistryLogin(
        request: CreateContainerServiceRegistryLoginRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest,
      CreateContainerServiceRegistryLoginResponse
    ](
      "createContainerServiceRegistryLogin",
      api.createContainerServiceRegistryLogin
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.wrap
      )
      .provide(r)
    def getDisk(request: GetDiskRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDiskRequest,
      GetDiskResponse
    ]("getDisk", api.getDisk)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.wrap)
      .provide(r)
    def enableAddOn(request: EnableAddOnRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.EnableAddOnResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest,
      EnableAddOnResponse
    ]("enableAddOn", api.enableAddOn)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.EnableAddOnResponse.wrap)
      .provide(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.wrap)
      .provide(r)
    def createLoadBalancerTlsCertificate(
        request: CreateLoadBalancerTlsCertificateRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest,
      CreateLoadBalancerTlsCertificateResponse
    ]("createLoadBalancerTlsCertificate", api.createLoadBalancerTlsCertificate)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.wrap
    ).provide(r)
    def getStaticIp(request: GetStaticIpRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest,
      GetStaticIpResponse
    ]("getStaticIp", api.getStaticIp)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.wrap)
      .provide(r)
    def attachStaticIp(request: AttachStaticIpRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AttachStaticIpResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest,
      AttachStaticIpResponse
    ]("attachStaticIp", api.attachStaticIp)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.AttachStaticIpResponse.wrap)
      .provide(r)
    def importKeyPair(request: ImportKeyPairRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest,
      ImportKeyPairResponse
    ]("importKeyPair", api.importKeyPair)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.wrap)
      .provide(r)
    def getDisks(request: GetDisksRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDisksRequest,
      GetDisksResponse
    ]("getDisks", api.getDisks)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.wrap)
      .provide(r)
    def downloadDefaultKeyPair(request: DownloadDefaultKeyPairRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest,
      DownloadDefaultKeyPairResponse
    ]("downloadDefaultKeyPair", api.downloadDefaultKeyPair)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.wrap
    ).provide(r)
    def getExportSnapshotRecords(request: GetExportSnapshotRecordsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest,
      GetExportSnapshotRecordsResponse
    ]("getExportSnapshotRecords", api.getExportSnapshotRecords)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.wrap
    ).provide(r)
    def createKeyPair(request: CreateKeyPairRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest,
      CreateKeyPairResponse
    ]("createKeyPair", api.createKeyPair)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.wrap)
      .provide(r)
    def getBundles(request: GetBundlesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetBundlesRequest,
      GetBundlesResponse
    ]("getBundles", api.getBundles)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.wrap)
      .provide(r)
    def registerContainerImage(request: RegisterContainerImageRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest,
      RegisterContainerImageResponse
    ]("registerContainerImage", api.registerContainerImage)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.wrap
    ).provide(r)
    def startInstance(request: StartInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.StartInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.StartInstanceRequest,
      StartInstanceResponse
    ]("startInstance", api.startInstance)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.StartInstanceResponse.wrap)
      .provide(r)
    def getInstancePortStates(request: GetInstancePortStatesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest,
      GetInstancePortStatesResponse
    ]("getInstancePortStates", api.getInstancePortStates)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.wrap
    ).provide(r)
    def deleteDisk(request: DeleteDiskRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteDiskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest,
      DeleteDiskResponse
    ]("deleteDisk", api.deleteDisk)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DeleteDiskResponse.wrap)
      .provide(r)
    def getBlueprints(request: GetBlueprintsRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest,
        GetBlueprintsResponse
      ]("getBlueprints", api.getBlueprints)(request.buildAwsValue())
        .map(io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse.wrap)
        .provide(r)
    def deleteAlarm(request: DeleteAlarmRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteAlarmResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest,
      DeleteAlarmResponse
    ]("deleteAlarm", api.deleteAlarm)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DeleteAlarmResponse.wrap)
      .provide(r)
    def createRelationalDatabaseSnapshot(
        request: CreateRelationalDatabaseSnapshotRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest,
      CreateRelationalDatabaseSnapshotResponse
    ]("createRelationalDatabaseSnapshot", api.createRelationalDatabaseSnapshot)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.wrap
    ).provide(r)
    def getContainerServiceMetricData(
        request: GetContainerServiceMetricDataRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest,
      GetContainerServiceMetricDataResponse
    ]("getContainerServiceMetricData", api.getContainerServiceMetricData)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.wrap
    ).provide(r)
    def getRelationalDatabaseLogStreams(
        request: GetRelationalDatabaseLogStreamsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest,
      GetRelationalDatabaseLogStreamsResponse
    ]("getRelationalDatabaseLogStreams", api.getRelationalDatabaseLogStreams)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.wrap
    ).provide(r)
    def updateRelationalDatabaseParameters(
        request: UpdateRelationalDatabaseParametersRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest,
      UpdateRelationalDatabaseParametersResponse
    ](
      "updateRelationalDatabaseParameters",
      api.updateRelationalDatabaseParameters
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersResponse.wrap
      )
      .provide(r)
    def createContainerServiceDeployment(
        request: CreateContainerServiceDeploymentRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest,
      CreateContainerServiceDeploymentResponse
    ]("createContainerServiceDeployment", api.createContainerServiceDeployment)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.wrap
    ).provide(r)
    def getDistributionLatestCacheReset(
        request: GetDistributionLatestCacheResetRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest,
      GetDistributionLatestCacheResetResponse
    ]("getDistributionLatestCacheReset", api.getDistributionLatestCacheReset)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.wrap
    ).provide(r)
    def updateDistributionBundle(request: UpdateDistributionBundleRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest,
      UpdateDistributionBundleResponse
    ]("updateDistributionBundle", api.updateDistributionBundle)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleResponse.wrap
    ).provide(r)
    def deleteKeyPair(request: DeleteKeyPairRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest,
      DeleteKeyPairResponse
    ]("deleteKeyPair", api.deleteKeyPair)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairResponse.wrap)
      .provide(r)
    def updateBucketBundle(request: UpdateBucketBundleRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest,
      UpdateBucketBundleResponse
    ]("updateBucketBundle", api.updateBucketBundle)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleResponse.wrap
      )
      .provide(r)
    def getStaticIps(request: GetStaticIpsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest,
      GetStaticIpsResponse
    ]("getStaticIps", api.getStaticIps)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.wrap)
      .provide(r)
    def createRelationalDatabase(request: CreateRelationalDatabaseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest,
      CreateRelationalDatabaseResponse
    ]("createRelationalDatabase", api.createRelationalDatabase)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseResponse.wrap
    ).provide(r)
    def getCertificates(request: GetCertificatesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest,
      GetCertificatesResponse
    ]("getCertificates", api.getCertificates)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.wrap)
      .provide(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.TagResourceResponse.wrap)
      .provide(r)
    def deleteDomain(request: DeleteDomainRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest,
      DeleteDomainResponse
    ]("deleteDomain", api.deleteDomain)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DeleteDomainResponse.wrap)
      .provide(r)
    def createBucketAccessKey(request: CreateBucketAccessKeyRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest,
      CreateBucketAccessKeyResponse
    ]("createBucketAccessKey", api.createBucketAccessKey)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.wrap
    ).provide(r)
    def getRelationalDatabaseSnapshots(
        request: GetRelationalDatabaseSnapshotsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest,
      GetRelationalDatabaseSnapshotsResponse
    ]("getRelationalDatabaseSnapshots", api.getRelationalDatabaseSnapshots)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.wrap
    ).provide(r)
    def createInstancesFromSnapshot(
        request: CreateInstancesFromSnapshotRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest,
      CreateInstancesFromSnapshotResponse
    ]("createInstancesFromSnapshot", api.createInstancesFromSnapshot)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotResponse.wrap
    ).provide(r)
    def exportSnapshot(request: ExportSnapshotRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest,
      ExportSnapshotResponse
    ]("exportSnapshot", api.exportSnapshot)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.ExportSnapshotResponse.wrap)
      .provide(r)
    def attachDisk(request: AttachDiskRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AttachDiskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachDiskRequest,
      AttachDiskResponse
    ]("attachDisk", api.attachDisk)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.AttachDiskResponse.wrap)
      .provide(r)
    def setIpAddressType(request: SetIpAddressTypeRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest,
      SetIpAddressTypeResponse
    ]("setIpAddressType", api.setIpAddressType)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeResponse.wrap)
      .provide(r)
    def getRegions(request: GetRegionsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRegionsRequest,
      GetRegionsResponse
    ]("getRegions", api.getRegions)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.wrap)
      .provide(r)
    def getRelationalDatabaseMetricData(
        request: GetRelationalDatabaseMetricDataRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest,
      GetRelationalDatabaseMetricDataResponse
    ]("getRelationalDatabaseMetricData", api.getRelationalDatabaseMetricData)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataResponse.wrap
    ).provide(r)
    def getOperation(request: GetOperationRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetOperationRequest,
      GetOperationResponse
    ]("getOperation", api.getOperation)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetOperationResponse.wrap)
      .provide(r)
    def stopInstance(request: StopInstanceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.StopInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.StopInstanceRequest,
      StopInstanceResponse
    ]("stopInstance", api.stopInstance)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.StopInstanceResponse.wrap)
      .provide(r)
    def getDistributionMetricData(
        request: GetDistributionMetricDataRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest,
      GetDistributionMetricDataResponse
    ]("getDistributionMetricData", api.getDistributionMetricData)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataResponse.wrap
    ).provide(r)
    def getKeyPairs(request: GetKeyPairsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest,
      GetKeyPairsResponse
    ]("getKeyPairs", api.getKeyPairs)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.wrap)
      .provide(r)
    def disableAddOn(request: DisableAddOnRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DisableAddOnResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest,
      DisableAddOnResponse
    ]("disableAddOn", api.disableAddOn)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.DisableAddOnResponse.wrap)
      .provide(r)
    def createInstances(request: CreateInstancesRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest,
      CreateInstancesResponse
    ]("createInstances", api.createInstances)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.CreateInstancesResponse.wrap)
      .provide(r)
    def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest,
      CreateLoadBalancerResponse
    ]("createLoadBalancer", api.createLoadBalancer)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerResponse.wrap
      )
      .provide(r)
    def getRelationalDatabaseBlueprints(
        request: GetRelationalDatabaseBlueprintsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest,
      GetRelationalDatabaseBlueprintsResponse
    ]("getRelationalDatabaseBlueprints", api.getRelationalDatabaseBlueprints)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.wrap
    ).provide(r)
    def detachCertificateFromDistribution(
        request: DetachCertificateFromDistributionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest,
      DetachCertificateFromDistributionResponse
    ](
      "detachCertificateFromDistribution",
      api.detachCertificateFromDistribution
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionResponse.wrap
      )
      .provide(r)
    def getRelationalDatabaseMasterUserPassword(
        request: GetRelationalDatabaseMasterUserPasswordRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest,
      GetRelationalDatabaseMasterUserPasswordResponse
    ](
      "getRelationalDatabaseMasterUserPassword",
      api.getRelationalDatabaseMasterUserPassword
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.wrap
      )
      .provide(r)
    def updateContainerService(request: UpdateContainerServiceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest,
      UpdateContainerServiceResponse
    ]("updateContainerService", api.updateContainerService)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceResponse.wrap
    ).provide(r)
    def getContainerServicePowers(
        request: GetContainerServicePowersRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest,
      GetContainerServicePowersResponse
    ]("getContainerServicePowers", api.getContainerServicePowers)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.wrap
    ).provide(r)
    def getRelationalDatabase(request: GetRelationalDatabaseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest,
      GetRelationalDatabaseResponse
    ]("getRelationalDatabase", api.getRelationalDatabase)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.wrap
    ).provide(r)
    def getBuckets(request: GetBucketsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetBucketsRequest,
      GetBucketsResponse
    ]("getBuckets", api.getBuckets)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.wrap)
      .provide(r)
    def getCloudFormationStackRecords(
        request: GetCloudFormationStackRecordsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest,
      GetCloudFormationStackRecordsResponse
    ]("getCloudFormationStackRecords", api.getCloudFormationStackRecords)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.wrap
    ).provide(r)
    def updateDistribution(request: UpdateDistributionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest,
      UpdateDistributionResponse
    ]("updateDistribution", api.updateDistribution)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.wrap
      )
      .provide(r)
    def deleteDistribution(request: DeleteDistributionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest,
      DeleteDistributionResponse
    ]("deleteDistribution", api.deleteDistribution)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteDistributionResponse.wrap
      )
      .provide(r)
    def deleteContainerImage(request: DeleteContainerImageRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest,
      DeleteContainerImageResponse
    ]("deleteContainerImage", api.deleteContainerImage)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageResponse.wrap
      )
      .provide(r)
    def createDistribution(request: CreateDistributionRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest,
      CreateDistributionResponse
    ]("createDistribution", api.createDistribution)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.wrap
      )
      .provide(r)
  }
  def putInstancePublicPorts(request: PutInstancePublicPortsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
  ] = ZIO.accessM(_.get.putInstancePublicPorts(request))
  def resetDistributionCache(request: ResetDistributionCacheRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
  ] = ZIO.accessM(_.get.resetDistributionCache(request))
  def getRelationalDatabaseSnapshot(
      request: GetRelationalDatabaseSnapshotRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseSnapshot(request))
  def getKeyPair(request: GetKeyPairRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly
  ] = ZIO.accessM(_.get.getKeyPair(request))
  def getInstanceAccessDetails(request: GetInstanceAccessDetailsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstanceAccessDetails(request))
  def deleteLoadBalancerTlsCertificate(
      request: DeleteLoadBalancerTlsCertificateRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteLoadBalancerTlsCertificate(request))
  def createDiskSnapshot(request: CreateDiskSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.createDiskSnapshot(request))
  def deleteRelationalDatabase(request: DeleteRelationalDatabaseRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteRelationalDatabase(request))
  def releaseStaticIp(request: ReleaseStaticIpRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
  ] = ZIO.accessM(_.get.releaseStaticIp(request))
  def updateLoadBalancerAttribute(
      request: UpdateLoadBalancerAttributeRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateLoadBalancerAttribute(request))
  def testAlarm(request: TestAlarmRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.TestAlarmResponse.ReadOnly
  ] = ZIO.accessM(_.get.testAlarm(request))
  def closeInstancePublicPorts(request: CloseInstancePublicPortsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
  ] = ZIO.accessM(_.get.closeInstancePublicPorts(request))
  def deleteContactMethod(request: DeleteContactMethodRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteContactMethod(request))
  def deleteDiskSnapshot(request: DeleteDiskSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteDiskSnapshot(request))
  def putAlarm(request: PutAlarmRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.PutAlarmResponse.ReadOnly
  ] = ZIO.accessM(_.get.putAlarm(request))
  def getInstances(request: GetInstancesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstances(request))
  def createCertificate(request: CreateCertificateRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly
  ] = ZIO.accessM(_.get.createCertificate(request))
  def getRelationalDatabaseLogEvents(
      request: GetRelationalDatabaseLogEventsRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseLogEvents(request))
  def deleteKnownHostKeys(request: DeleteKnownHostKeysRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteKnownHostKeys(request))
  def rebootRelationalDatabase(request: RebootRelationalDatabaseRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
  ] = ZIO.accessM(_.get.rebootRelationalDatabase(request))
  def createCloudFormationStack(request: CreateCloudFormationStackRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
  ] = ZIO.accessM(_.get.createCloudFormationStack(request))
  def getBucketMetricData(request: GetBucketMetricDataRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketMetricData(request))
  def detachDisk(request: DetachDiskRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DetachDiskResponse.ReadOnly
  ] = ZIO.accessM(_.get.detachDisk(request))
  def allocateStaticIp(request: AllocateStaticIpRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.AllocateStaticIpResponse.ReadOnly
  ] = ZIO.accessM(_.get.allocateStaticIp(request))
  def getRelationalDatabaseEvents(
      request: GetRelationalDatabaseEventsRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseEvents(request))
  def getOperations(request: GetOperationsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetOperationsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getOperations(request))
  def getInstanceState(request: GetInstanceStateRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstanceStateResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstanceState(request))
  def getDomains(request: GetDomainsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDomains(request))
  def getLoadBalancers(request: GetLoadBalancersRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLoadBalancers(request))
  def getContainerServices(request: GetContainerServicesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContainerServicesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContainerServices(request))
  def getLoadBalancerTlsCertificates(
      request: GetLoadBalancerTlsCertificatesRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLoadBalancerTlsCertificates(request))
  def createRelationalDatabaseFromSnapshot(
      request: CreateRelationalDatabaseFromSnapshotRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.createRelationalDatabaseFromSnapshot(request))
  def getInstanceSnapshot(request: GetInstanceSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstanceSnapshot(request))
  def deleteContainerService(request: DeleteContainerServiceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteContainerService(request))
  def getContainerAPIMetadata(request: GetContainerApiMetadataRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContainerAPIMetadata(request))
  def getDiskSnapshot(request: GetDiskSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDiskSnapshot(request))
  def detachStaticIp(request: DetachStaticIpRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DetachStaticIpResponse.ReadOnly
  ] = ZIO.accessM(_.get.detachStaticIp(request))
  def createDisk(request: CreateDiskRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateDiskResponse.ReadOnly
  ] = ZIO.accessM(_.get.createDisk(request))
  def getContainerImages(request: GetContainerImagesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContainerImages(request))
  def deleteBucketAccessKey(request: DeleteBucketAccessKeyRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteBucketAccessKey(request))
  def createDomainEntry(request: CreateDomainEntryRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly
  ] = ZIO.accessM(_.get.createDomainEntry(request))
  def sendContactMethodVerification(
      request: SendContactMethodVerificationRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
  ] = ZIO.accessM(_.get.sendContactMethodVerification(request))
  def getDomain(request: GetDomainRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDomainResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDomain(request))
  def deleteInstance(request: DeleteInstanceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteInstance(request))
  def copySnapshot(request: CopySnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CopySnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.copySnapshot(request))
  def getContactMethods(request: GetContactMethodsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContactMethods(request))
  def getRelationalDatabaseBundles(
      request: GetRelationalDatabaseBundlesRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseBundles(request))
  def detachInstancesFromLoadBalancer(
      request: DetachInstancesFromLoadBalancerRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
  ] = ZIO.accessM(_.get.detachInstancesFromLoadBalancer(request))
  def openInstancePublicPorts(request: OpenInstancePublicPortsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
  ] = ZIO.accessM(_.get.openInstancePublicPorts(request))
  def getInstanceMetricData(request: GetInstanceMetricDataRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstanceMetricData(request))
  def deleteRelationalDatabaseSnapshot(
      request: DeleteRelationalDatabaseSnapshotRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteRelationalDatabaseSnapshot(request))
  def attachInstancesToLoadBalancer(
      request: AttachInstancesToLoadBalancerRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
  ] = ZIO.accessM(_.get.attachInstancesToLoadBalancer(request))
  def getDistributionBundles(request: GetDistributionBundlesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDistributionBundles(request))
  def getRelationalDatabaseParameters(
      request: GetRelationalDatabaseParametersRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseParameters(request))
  def getAlarms(request: GetAlarmsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetAlarmsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getAlarms(request))
  def deleteLoadBalancer(request: DeleteLoadBalancerRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteLoadBalancer(request))
  def getInstanceSnapshots(request: GetInstanceSnapshotsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstanceSnapshots(request))
  def stopRelationalDatabase(request: StopRelationalDatabaseRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
  ] = ZIO.accessM(_.get.stopRelationalDatabase(request))
  def getLoadBalancerMetricData(request: GetLoadBalancerMetricDataRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLoadBalancerMetricData(request))
  def attachCertificateToDistribution(
      request: AttachCertificateToDistributionRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
  ] = ZIO.accessM(_.get.attachCertificateToDistribution(request))
  def deleteCertificate(request: DeleteCertificateRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteCertificateResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteCertificate(request))
  def getInstance(request: GetInstanceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstance(request))
  def getDistributions(request: GetDistributionsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDistributions(request))
  def getRelationalDatabases(request: GetRelationalDatabasesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabases(request))
  def attachLoadBalancerTlsCertificate(
      request: AttachLoadBalancerTlsCertificateRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
  ] = ZIO.accessM(_.get.attachLoadBalancerTlsCertificate(request))
  def getOperationsForResource(request: GetOperationsForResourceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.getOperationsForResource(request))
  def createDiskFromSnapshot(request: CreateDiskFromSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.createDiskFromSnapshot(request))
  def getLoadBalancer(request: GetLoadBalancerRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly
  ] = ZIO.accessM(_.get.getLoadBalancer(request))
  def getBucketBundles(request: GetBucketBundlesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketBundles(request))
  def deleteInstanceSnapshot(request: DeleteInstanceSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteInstanceSnapshot(request))
  def deleteDomainEntry(request: DeleteDomainEntryRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteDomainEntry(request))
  def updateRelationalDatabase(request: UpdateRelationalDatabaseRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateRelationalDatabase(request))
  def peerVpc(request: PeerVpcRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.PeerVpcResponse.ReadOnly
  ] = ZIO.accessM(_.get.peerVpc(request))
  def unpeerVpc(request: UnpeerVpcRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UnpeerVpcResponse.ReadOnly
  ] = ZIO.accessM(_.get.unpeerVpc(request))
  def getActiveNames(request: GetActiveNamesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetActiveNamesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getActiveNames(request))
  def deleteBucket(request: DeleteBucketRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteBucketResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteBucket(request))
  def getAutoSnapshots(request: GetAutoSnapshotsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getAutoSnapshots(request))
  def startRelationalDatabase(request: StartRelationalDatabaseRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
  ] = ZIO.accessM(_.get.startRelationalDatabase(request))
  def createInstanceSnapshot(request: CreateInstanceSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.createInstanceSnapshot(request))
  def updateDomainEntry(request: UpdateDomainEntryRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateDomainEntry(request))
  def updateBucket(request: UpdateBucketRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateBucketResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateBucket(request))
  def rebootInstance(request: RebootInstanceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.RebootInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.rebootInstance(request))
  def createContactMethod(request: CreateContactMethodRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateContactMethodResponse.ReadOnly
  ] = ZIO.accessM(_.get.createContactMethod(request))
  def getDiskSnapshots(request: GetDiskSnapshotsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDiskSnapshots(request))
  def createBucket(request: CreateBucketRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateBucketResponse.ReadOnly
  ] = ZIO.accessM(_.get.createBucket(request))
  def getContainerLog(request: GetContainerLogRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContainerLog(request))
  def getContainerServiceDeployments(
      request: GetContainerServiceDeploymentsRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContainerServiceDeployments(request))
  def createDomain(request: CreateDomainRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateDomainResponse.ReadOnly
  ] = ZIO.accessM(_.get.createDomain(request))
  def setResourceAccessForBucket(
      request: SetResourceAccessForBucketRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
  ] = ZIO.accessM(_.get.setResourceAccessForBucket(request))
  def getBucketAccessKeys(request: GetBucketAccessKeysRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketAccessKeys(request))
  def createContainerService(request: CreateContainerServiceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly
  ] = ZIO.accessM(_.get.createContainerService(request))
  def isVpcPeered(request: IsVpcPeeredRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly
  ] = ZIO.accessM(_.get.isVpcPeered(request))
  def deleteAutoSnapshot(request: DeleteAutoSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteAutoSnapshot(request))
  def createContainerServiceRegistryLogin(
      request: CreateContainerServiceRegistryLoginRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
  ] = ZIO.accessM(_.get.createContainerServiceRegistryLogin(request))
  def getDisk(request: GetDiskRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDisk(request))
  def enableAddOn(request: EnableAddOnRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.EnableAddOnResponse.ReadOnly
  ] = ZIO.accessM(_.get.enableAddOn(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.untagResource(request))
  def createLoadBalancerTlsCertificate(
      request: CreateLoadBalancerTlsCertificateRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
  ] = ZIO.accessM(_.get.createLoadBalancerTlsCertificate(request))
  def getStaticIp(request: GetStaticIpRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly
  ] = ZIO.accessM(_.get.getStaticIp(request))
  def attachStaticIp(request: AttachStaticIpRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.AttachStaticIpResponse.ReadOnly
  ] = ZIO.accessM(_.get.attachStaticIp(request))
  def importKeyPair(request: ImportKeyPairRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly
  ] = ZIO.accessM(_.get.importKeyPair(request))
  def getDisks(request: GetDisksRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDisks(request))
  def downloadDefaultKeyPair(request: DownloadDefaultKeyPairRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
  ] = ZIO.accessM(_.get.downloadDefaultKeyPair(request))
  def getExportSnapshotRecords(request: GetExportSnapshotRecordsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getExportSnapshotRecords(request))
  def createKeyPair(request: CreateKeyPairRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly
  ] = ZIO.accessM(_.get.createKeyPair(request))
  def getBundles(request: GetBundlesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetBundlesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBundles(request))
  def registerContainerImage(request: RegisterContainerImageRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly
  ] = ZIO.accessM(_.get.registerContainerImage(request))
  def startInstance(request: StartInstanceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.StartInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.startInstance(request))
  def getInstancePortStates(request: GetInstancePortStatesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getInstancePortStates(request))
  def deleteDisk(request: DeleteDiskRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteDiskResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteDisk(request))
  def getBlueprints(
      request: GetBlueprintsRequest
  ): ZIO[Lightsail, AwsError, ReadOnly] =
    ZIO.accessM(_.get.getBlueprints(request))
  def deleteAlarm(request: DeleteAlarmRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteAlarmResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteAlarm(request))
  def createRelationalDatabaseSnapshot(
      request: CreateRelationalDatabaseSnapshotRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.createRelationalDatabaseSnapshot(request))
  def getContainerServiceMetricData(
      request: GetContainerServiceMetricDataRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContainerServiceMetricData(request))
  def getRelationalDatabaseLogStreams(
      request: GetRelationalDatabaseLogStreamsRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseLogStreams(request))
  def updateRelationalDatabaseParameters(
      request: UpdateRelationalDatabaseParametersRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateRelationalDatabaseParameters(request))
  def createContainerServiceDeployment(
      request: CreateContainerServiceDeploymentRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
  ] = ZIO.accessM(_.get.createContainerServiceDeployment(request))
  def getDistributionLatestCacheReset(
      request: GetDistributionLatestCacheResetRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDistributionLatestCacheReset(request))
  def updateDistributionBundle(request: UpdateDistributionBundleRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateDistributionBundle(request))
  def deleteKeyPair(request: DeleteKeyPairRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteKeyPairResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteKeyPair(request))
  def updateBucketBundle(request: UpdateBucketBundleRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateBucketBundle(request))
  def getStaticIps(request: GetStaticIpsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getStaticIps(request))
  def createRelationalDatabase(request: CreateRelationalDatabaseRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
  ] = ZIO.accessM(_.get.createRelationalDatabase(request))
  def getCertificates(request: GetCertificatesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getCertificates(request))
  def tagResource(request: TagResourceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.TagResourceResponse.ReadOnly
  ] = ZIO.accessM(_.get.tagResource(request))
  def deleteDomain(request: DeleteDomainRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteDomainResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteDomain(request))
  def createBucketAccessKey(request: CreateBucketAccessKeyRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
  ] = ZIO.accessM(_.get.createBucketAccessKey(request))
  def getRelationalDatabaseSnapshots(
      request: GetRelationalDatabaseSnapshotsRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseSnapshots(request))
  def createInstancesFromSnapshot(
      request: CreateInstancesFromSnapshotRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.createInstancesFromSnapshot(request))
  def exportSnapshot(request: ExportSnapshotRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.ExportSnapshotResponse.ReadOnly
  ] = ZIO.accessM(_.get.exportSnapshot(request))
  def attachDisk(request: AttachDiskRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.AttachDiskResponse.ReadOnly
  ] = ZIO.accessM(_.get.attachDisk(request))
  def setIpAddressType(request: SetIpAddressTypeRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
  ] = ZIO.accessM(_.get.setIpAddressType(request))
  def getRegions(request: GetRegionsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRegions(request))
  def getRelationalDatabaseMetricData(
      request: GetRelationalDatabaseMetricDataRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseMetricData(request))
  def getOperation(request: GetOperationRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetOperationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getOperation(request))
  def stopInstance(request: StopInstanceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.StopInstanceResponse.ReadOnly
  ] = ZIO.accessM(_.get.stopInstance(request))
  def getDistributionMetricData(request: GetDistributionMetricDataRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
  ] = ZIO.accessM(_.get.getDistributionMetricData(request))
  def getKeyPairs(request: GetKeyPairsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getKeyPairs(request))
  def disableAddOn(request: DisableAddOnRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DisableAddOnResponse.ReadOnly
  ] = ZIO.accessM(_.get.disableAddOn(request))
  def createInstances(request: CreateInstancesRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateInstancesResponse.ReadOnly
  ] = ZIO.accessM(_.get.createInstances(request))
  def createLoadBalancer(request: CreateLoadBalancerRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
  ] = ZIO.accessM(_.get.createLoadBalancer(request))
  def getRelationalDatabaseBlueprints(
      request: GetRelationalDatabaseBlueprintsRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseBlueprints(request))
  def detachCertificateFromDistribution(
      request: DetachCertificateFromDistributionRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
  ] = ZIO.accessM(_.get.detachCertificateFromDistribution(request))
  def getRelationalDatabaseMasterUserPassword(
      request: GetRelationalDatabaseMasterUserPasswordRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabaseMasterUserPassword(request))
  def updateContainerService(request: UpdateContainerServiceRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateContainerService(request))
  def getContainerServicePowers(request: GetContainerServicePowersRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
  ] = ZIO.accessM(_.get.getContainerServicePowers(request))
  def getRelationalDatabase(request: GetRelationalDatabaseRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
  ] = ZIO.accessM(_.get.getRelationalDatabase(request))
  def getBuckets(request: GetBucketsRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBuckets(request))
  def getCloudFormationStackRecords(
      request: GetCloudFormationStackRecordsRequest
  ): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getCloudFormationStackRecords(request))
  def updateDistribution(request: UpdateDistributionRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateDistribution(request))
  def deleteDistribution(request: DeleteDistributionRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteDistributionResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteDistribution(request))
  def deleteContainerImage(request: DeleteContainerImageRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteContainerImage(request))
  def createDistribution(request: CreateDistributionRequest): ZIO[
    Lightsail,
    AwsError,
    io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly
  ] = ZIO.accessM(_.get.createDistribution(request))
}
