package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetDistributionCacheResponse(
    status: Option[String] = None,
    createTime: Option[IsoDate] = None,
    operation: Option[io.github.vigoo.zioaws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse = {
    import ResetDistributionCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(createTime.map(value => value: Instant))(_.createTime)
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse
      .wrap(buildAwsValue())
}
object ResetDistributionCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse =
      io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse(
        statusValue.map(value => value),
        createTimeValue.map(value => value),
        operationValue.map(value => value.editable)
      )
    def statusValue: Option[String]
    def createTimeValue: Option[IsoDate]
    def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def createTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createTime", createTimeValue)
    def operation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ] = AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly {
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def createTimeValue: Option[IsoDate] =
      scala.Option(impl.createTime()).map(value => value: IsoDate)
    override def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
  ): io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheResponse.ReadOnly =
    new Wrapper(impl)
}
