package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseHardware(
    cpuCount: Option[Integer] = None,
    diskSizeInGb: Option[Integer] = None,
    ramSizeInGb: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware = {
    import RelationalDatabaseHardware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
      .builder()
      .optionallyWith(cpuCount.map(value => value: java.lang.Integer))(
        _.cpuCount
      )
      .optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(
        _.diskSizeInGb
      )
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware
      .wrap(buildAwsValue())
}
object RelationalDatabaseHardware {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware(
        cpuCountValue.map(value => value),
        diskSizeInGbValue.map(value => value),
        ramSizeInGbValue.map(value => value)
      )
    def cpuCountValue: Option[Integer]
    def diskSizeInGbValue: Option[Integer]
    def ramSizeInGbValue: Option[Float]
    def cpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def diskSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGbValue)
    def ramSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware.ReadOnly {
    override def cpuCountValue: Option[Integer] =
      scala.Option(impl.cpuCount()).map(value => value: Integer)
    override def diskSizeInGbValue: Option[Integer] =
      scala.Option(impl.diskSizeInGb()).map(value => value: Integer)
    override def ramSizeInGbValue: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseHardware
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseHardware.ReadOnly =
    new Wrapper(impl)
}
