package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QueryStringObject(
    option: Option[Boolean] = None,
    queryStringsAllowList: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.QueryStringObject = {
    import QueryStringObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.QueryStringObject
      .builder()
      .optionallyWith(option.map(value => value: java.lang.Boolean))(_.option)
      .optionallyWith(
        queryStringsAllowList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.queryStringsAllowList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.QueryStringObject.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.QueryStringObject
      .wrap(buildAwsValue())
}
object QueryStringObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.QueryStringObject =
      io.github.vigoo.zioaws.lightsail.model.QueryStringObject(
        optionValue.map(value => value),
        queryStringsAllowListValue.map(value => value)
      )
    def optionValue: Option[Boolean]
    def queryStringsAllowListValue: Option[List[String]]
    def option: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("option", optionValue)
    def queryStringsAllowList: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("queryStringsAllowList", queryStringsAllowListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ) extends io.github.vigoo.zioaws.lightsail.model.QueryStringObject.ReadOnly {
    override def optionValue: Option[Boolean] =
      scala.Option(impl.option()).map(value => value: Boolean)
    override def queryStringsAllowListValue: Option[List[String]] = scala
      .Option(impl.queryStringsAllowList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.QueryStringObject
  ): io.github.vigoo.zioaws.lightsail.model.QueryStringObject.ReadOnly =
    new Wrapper(impl)
}
