package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PasswordData(
    ciphertext: Option[String] = None,
    keyPairName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PasswordData = {
    import PasswordData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PasswordData
      .builder()
      .optionallyWith(ciphertext.map(value => value: java.lang.String))(
        _.ciphertext
      )
      .optionallyWith(keyPairName.map(value => value: java.lang.String))(
        _.keyPairName
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.PasswordData.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.PasswordData.wrap(buildAwsValue())
}
object PasswordData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PasswordData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.PasswordData =
      io.github.vigoo.zioaws.lightsail.model.PasswordData(
        ciphertextValue.map(value => value),
        keyPairNameValue.map(value => value)
      )
    def ciphertextValue: Option[String]
    def keyPairNameValue: Option[ResourceName]
    def ciphertext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ciphertext", ciphertextValue)
    def keyPairName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("keyPairName", keyPairNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PasswordData
  ) extends io.github.vigoo.zioaws.lightsail.model.PasswordData.ReadOnly {
    override def ciphertextValue: Option[String] =
      scala.Option(impl.ciphertext()).map(value => value: String)
    override def keyPairNameValue: Option[ResourceName] =
      scala.Option(impl.keyPairName()).map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PasswordData
  ): io.github.vigoo.zioaws.lightsail.model.PasswordData.ReadOnly = new Wrapper(
    impl
  )
}
