package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificateSummary(
    name: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary = {
    import LoadBalancerTlsCertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary =
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary(
        nameValue.map(value => value),
        isAttachedValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def isAttachedValue: Option[Boolean]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def isAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttachedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
  ) extends io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def isAttachedValue: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
  ): io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly =
    new Wrapper(impl)
}
