package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceSnapshotState {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState
}
object InstanceSnapshotState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState
  ): io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState =
    value match {
      case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.PENDING =>
        val r = pending
        r
      case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.ERROR =>
        val r = error
        r
      case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.AVAILABLE =>
        val r = available
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState =
      software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending
      extends io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState =
      software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.PENDING
  }
  case object error
      extends io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState =
      software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.ERROR
  }
  case object available
      extends io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState =
      software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.AVAILABLE
  }
}
