package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{IsoDate, ResourceName}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseLogEventsRequest(
    relationalDatabaseName: ResourceName,
    logStreamName: String,
    startTime: Option[IsoDate] = None,
    endTime: Option[IsoDate] = None,
    startFromHead: Option[Boolean] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest = {
    import GetRelationalDatabaseLogEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .logStreamName(logStreamName: java.lang.String)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(startFromHead.map(value => value: java.lang.Boolean))(
        _.startFromHead
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseLogEventsRequest(
          relationalDatabaseNameValue,
          logStreamNameValue,
          startTimeValue.map(value => value),
          endTimeValue.map(value => value),
          startFromHeadValue.map(value => value),
          pageTokenValue.map(value => value)
        )
    def relationalDatabaseNameValue: ResourceName
    def logStreamNameValue: String
    def startTimeValue: Option[IsoDate]
    def endTimeValue: Option[IsoDate]
    def startFromHeadValue: Option[Boolean]
    def pageTokenValue: Option[String]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def logStreamName: ZIO[Any, Nothing, String] =
      ZIO.succeed(logStreamNameValue)
    def startTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("startTime", startTimeValue)
    def endTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("endTime", endTimeValue)
    def startFromHead: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("startFromHead", startFromHeadValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def logStreamNameValue: String = impl.logStreamName(): String
    override def startTimeValue: Option[IsoDate] =
      scala.Option(impl.startTime()).map(value => value: IsoDate)
    override def endTimeValue: Option[IsoDate] =
      scala.Option(impl.endTime()).map(value => value: IsoDate)
    override def startFromHeadValue: Option[Boolean] =
      scala.Option(impl.startFromHead()).map(value => value: Boolean)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsRequest.ReadOnly =
    new Wrapper(impl)
}
