package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerMetricDataResponse(
    metricName: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName
    ] = None,
    metricData: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.MetricDatapoint]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse = {
    import GetLoadBalancerMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse
      .wrap(buildAwsValue())
}
object GetLoadBalancerMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse =
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse(
        metricNameValue.map(value => value),
        metricDataValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def metricNameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName]
    def metricDataValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly]
    ]
    def metricName: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName
    ] = AwsError.unwrapOptionField("metricName", metricNameValue)
    def metricData: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricDataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly {
    override def metricNameValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName
    ] = scala
      .Option(impl.metricName())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerMetricName
          .wrap(value)
      )
    override def metricDataValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly]
    ] = scala
      .Option(impl.metricData())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
