package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDistributionBundlesResponse(
    bundles: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.DistributionBundle]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse = {
    import GetDistributionBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse
      .wrap(buildAwsValue())
}
object GetDistributionBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse(
        bundlesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def bundlesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.DistributionBundle.ReadOnly]
    ]
    def bundles: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.DistributionBundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundlesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly {
    override def bundlesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.DistributionBundle.ReadOnly]
    ] = scala
      .Option(impl.bundles())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.DistributionBundle.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDistributionBundlesResponse.ReadOnly =
    new Wrapper(impl)
}
