package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDiskResponse(
    disk: Option[io.github.vigoo.zioaws.lightsail.model.Disk] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskResponse = {
    import GetDiskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskResponse
      .builder()
      .optionallyWith(disk.map(value => value.buildAwsValue()))(_.disk)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.wrap(buildAwsValue())
}
object GetDiskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetDiskResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetDiskResponse(diskValue.map(value => value.editable))
    def diskValue: Option[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly]
    def disk: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly
    ] = AwsError.unwrapOptionField("disk", diskValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly {
    override def diskValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly] = scala
      .Option(impl.disk())
      .map(value => io.github.vigoo.zioaws.lightsail.model.Disk.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDiskResponse.ReadOnly =
    new Wrapper(impl)
}
