package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachCertificateFromDistributionRequest(
    distributionName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest = {
    import DetachCertificateFromDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
      .builder()
      .distributionName(distributionName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionRequest
      .wrap(buildAwsValue())
}
object DetachCertificateFromDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DetachCertificateFromDistributionRequest(distributionNameValue)
    def distributionNameValue: ResourceName
    def distributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionRequest.ReadOnly {
    override def distributionNameValue: ResourceName =
      impl.distributionName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest
  ): io.github.vigoo.zioaws.lightsail.model.DetachCertificateFromDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
