package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAlarmRequest(alarmName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest = {
    import DeleteAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
      .builder()
      .alarmName(alarmName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteAlarmRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteAlarmRequest
      .wrap(buildAwsValue())
}
object DeleteAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DeleteAlarmRequest =
      io.github.vigoo.zioaws.lightsail.model.DeleteAlarmRequest(alarmNameValue)
    def alarmNameValue: ResourceName
    def alarmName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(alarmNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteAlarmRequest.ReadOnly {
    override def alarmNameValue: ResourceName = impl.alarmName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteAlarmRequest.ReadOnly =
    new Wrapper(impl)
}
