package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBucketRequest(
    bucketName: BucketName,
    bundleId: NonEmptyString,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    enableObjectVersioning: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateBucketRequest = {
    import CreateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
      .builder()
      .bucketName(bucketName: java.lang.String)
      .bundleId(bundleId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableObjectVersioning.map(value => value: java.lang.Boolean)
      )(_.enableObjectVersioning)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateBucketRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateBucketRequest
      .wrap(buildAwsValue())
}
object CreateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CreateBucketRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateBucketRequest(
        bucketNameValue,
        bundleIdValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        enableObjectVersioningValue.map(value => value)
      )
    def bucketNameValue: BucketName
    def bundleIdValue: NonEmptyString
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def enableObjectVersioningValue: Option[Boolean]
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def bundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleIdValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def enableObjectVersioning: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableObjectVersioning", enableObjectVersioningValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateBucketRequest.ReadOnly {
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def bundleIdValue: NonEmptyString = impl.bundleId(): NonEmptyString
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def enableObjectVersioningValue: Option[Boolean] =
      scala.Option(impl.enableObjectVersioning()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateBucketRequest.ReadOnly =
    new Wrapper(impl)
}
