package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServiceRegistryLogin(
    username: Option[String] = None,
    password: Option[String] = None,
    expiresAt: Option[IsoDate] = None,
    registry: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin = {
    import ContainerServiceRegistryLogin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(password.map(value => value: java.lang.String))(
        _.password
      )
      .optionallyWith(expiresAt.map(value => value: Instant))(_.expiresAt)
      .optionallyWith(registry.map(value => value: java.lang.String))(
        _.registry
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin
      .wrap(buildAwsValue())
}
object ContainerServiceRegistryLogin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin =
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin(
        usernameValue.map(value => value),
        passwordValue.map(value => value),
        expiresAtValue.map(value => value),
        registryValue.map(value => value)
      )
    def usernameValue: Option[String]
    def passwordValue: Option[String]
    def expiresAtValue: Option[IsoDate]
    def registryValue: Option[String]
    def username: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", usernameValue)
    def password: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("password", passwordValue)
    def expiresAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("expiresAt", expiresAtValue)
    def registry: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registry", registryValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly {
    override def usernameValue: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override def passwordValue: Option[String] =
      scala.Option(impl.password()).map(value => value: String)
    override def expiresAtValue: Option[IsoDate] =
      scala.Option(impl.expiresAt()).map(value => value: IsoDate)
    override def registryValue: Option[String] =
      scala.Option(impl.registry()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly =
    new Wrapper(impl)
}
