package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServiceLogEvent(
    createdAt: Option[IsoDate] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent = {
    import ContainerServiceLogEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
      .builder()
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent
      .wrap(buildAwsValue())
}
object ContainerServiceLogEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent =
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent(
        createdAtValue.map(value => value),
        messageValue.map(value => value)
      )
    def createdAtValue: Option[IsoDate]
    def messageValue: Option[String]
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def message: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent.ReadOnly {
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def messageValue: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceLogEvent
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent.ReadOnly =
    new Wrapper(impl)
}
