package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CacheSettings(
    defaultTTL: Option[Long] = None,
    minimumTTL: Option[Long] = None,
    maximumTTL: Option[Long] = None,
    allowedHTTPMethods: Option[NonEmptyString] = None,
    cachedHTTPMethods: Option[NonEmptyString] = None,
    forwardedCookies: Option[
      io.github.vigoo.zioaws.lightsail.model.CookieObject
    ] = None,
    forwardedHeaders: Option[
      io.github.vigoo.zioaws.lightsail.model.HeaderObject
    ] = None,
    forwardedQueryStrings: Option[
      io.github.vigoo.zioaws.lightsail.model.QueryStringObject
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CacheSettings = {
    import CacheSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheSettings
      .builder()
      .optionallyWith(defaultTTL.map(value => value: java.lang.Long))(
        _.defaultTTL
      )
      .optionallyWith(minimumTTL.map(value => value: java.lang.Long))(
        _.minimumTTL
      )
      .optionallyWith(maximumTTL.map(value => value: java.lang.Long))(
        _.maximumTTL
      )
      .optionallyWith(allowedHTTPMethods.map(value => value: java.lang.String))(
        _.allowedHTTPMethods
      )
      .optionallyWith(cachedHTTPMethods.map(value => value: java.lang.String))(
        _.cachedHTTPMethods
      )
      .optionallyWith(forwardedCookies.map(value => value.buildAwsValue()))(
        _.forwardedCookies
      )
      .optionallyWith(forwardedHeaders.map(value => value.buildAwsValue()))(
        _.forwardedHeaders
      )
      .optionallyWith(
        forwardedQueryStrings.map(value => value.buildAwsValue())
      )(_.forwardedQueryStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CacheSettings.wrap(buildAwsValue())
}
object CacheSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CacheSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CacheSettings =
      io.github.vigoo.zioaws.lightsail.model.CacheSettings(
        defaultTTLValue.map(value => value),
        minimumTTLValue.map(value => value),
        maximumTTLValue.map(value => value),
        allowedHTTPMethodsValue.map(value => value),
        cachedHTTPMethodsValue.map(value => value),
        forwardedCookiesValue.map(value => value.editable),
        forwardedHeadersValue.map(value => value.editable),
        forwardedQueryStringsValue.map(value => value.editable)
      )
    def defaultTTLValue: Option[Long]
    def minimumTTLValue: Option[Long]
    def maximumTTLValue: Option[Long]
    def allowedHTTPMethodsValue: Option[NonEmptyString]
    def cachedHTTPMethodsValue: Option[NonEmptyString]
    def forwardedCookiesValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CookieObject.ReadOnly]
    def forwardedHeadersValue
        : Option[io.github.vigoo.zioaws.lightsail.model.HeaderObject.ReadOnly]
    def forwardedQueryStringsValue: Option[
      io.github.vigoo.zioaws.lightsail.model.QueryStringObject.ReadOnly
    ]
    def defaultTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultTTL", defaultTTLValue)
    def minimumTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minimumTTL", minimumTTLValue)
    def maximumTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maximumTTL", maximumTTLValue)
    def allowedHTTPMethods: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("allowedHTTPMethods", allowedHTTPMethodsValue)
    def cachedHTTPMethods: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cachedHTTPMethods", cachedHTTPMethodsValue)
    def forwardedCookies: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CookieObject.ReadOnly
    ] = AwsError.unwrapOptionField("forwardedCookies", forwardedCookiesValue)
    def forwardedHeaders: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.HeaderObject.ReadOnly
    ] = AwsError.unwrapOptionField("forwardedHeaders", forwardedHeadersValue)
    def forwardedQueryStrings: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.QueryStringObject.ReadOnly
    ] = AwsError.unwrapOptionField(
      "forwardedQueryStrings",
      forwardedQueryStringsValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CacheSettings
  ) extends io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly {
    override def defaultTTLValue: Option[Long] =
      scala.Option(impl.defaultTTL()).map(value => value: Long)
    override def minimumTTLValue: Option[Long] =
      scala.Option(impl.minimumTTL()).map(value => value: Long)
    override def maximumTTLValue: Option[Long] =
      scala.Option(impl.maximumTTL()).map(value => value: Long)
    override def allowedHTTPMethodsValue: Option[NonEmptyString] = scala
      .Option(impl.allowedHTTPMethods())
      .map(value => value: NonEmptyString)
    override def cachedHTTPMethodsValue: Option[NonEmptyString] =
      scala.Option(impl.cachedHTTPMethods()).map(value => value: NonEmptyString)
    override def forwardedCookiesValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CookieObject.ReadOnly] =
      scala
        .Option(impl.forwardedCookies())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.CookieObject.wrap(value)
        )
    override def forwardedHeadersValue
        : Option[io.github.vigoo.zioaws.lightsail.model.HeaderObject.ReadOnly] =
      scala
        .Option(impl.forwardedHeaders())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.HeaderObject.wrap(value)
        )
    override def forwardedQueryStringsValue: Option[
      io.github.vigoo.zioaws.lightsail.model.QueryStringObject.ReadOnly
    ] = scala
      .Option(impl.forwardedQueryStrings())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.QueryStringObject.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CacheSettings
  ): io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly =
    new Wrapper(impl)
}
