package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CacheBehaviorPerPath(
    path: Option[String] = None,
    behavior: Option[io.github.vigoo.zioaws.lightsail.model.BehaviorEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath = {
    import CacheBehaviorPerPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
      .builder()
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(behavior.map(value => value.unwrap))(_.behavior)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath
      .wrap(buildAwsValue())
}
object CacheBehaviorPerPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath =
      io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath(
        pathValue.map(value => value),
        behaviorValue.map(value => value)
      )
    def pathValue: Option[String]
    def behaviorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.BehaviorEnum]
    def path: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", pathValue)
    def behavior: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.BehaviorEnum
    ] = AwsError.unwrapOptionField("behavior", behaviorValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
  ) extends io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly {
    override def pathValue: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override def behaviorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.BehaviorEnum] = scala
      .Option(impl.behavior())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.BehaviorEnum.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehaviorPerPath
  ): io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly =
    new Wrapper(impl)
}
