package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.TimeOfDay
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddOn(
    name: Option[String] = None,
    status: Option[String] = None,
    snapshotTimeOfDay: Option[TimeOfDay] = None,
    nextSnapshotTimeOfDay: Option[TimeOfDay] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AddOn = {
    import AddOn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOn
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(snapshotTimeOfDay.map(value => value: java.lang.String))(
        _.snapshotTimeOfDay
      )
      .optionallyWith(
        nextSnapshotTimeOfDay.map(value => value: java.lang.String)
      )(_.nextSnapshotTimeOfDay)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AddOn.wrap(buildAwsValue())
}
object AddOn {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.AddOn] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AddOn =
      io.github.vigoo.zioaws.lightsail.model.AddOn(
        nameValue.map(value => value),
        statusValue.map(value => value),
        snapshotTimeOfDayValue.map(value => value),
        nextSnapshotTimeOfDayValue.map(value => value)
      )
    def nameValue: Option[String]
    def statusValue: Option[String]
    def snapshotTimeOfDayValue: Option[TimeOfDay]
    def nextSnapshotTimeOfDayValue: Option[TimeOfDay]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def snapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] =
      AwsError.unwrapOptionField("snapshotTimeOfDay", snapshotTimeOfDayValue)
    def nextSnapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] = AwsError
      .unwrapOptionField("nextSnapshotTimeOfDay", nextSnapshotTimeOfDayValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AddOn
  ) extends io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def snapshotTimeOfDayValue: Option[TimeOfDay] =
      scala.Option(impl.snapshotTimeOfDay()).map(value => value: TimeOfDay)
    override def nextSnapshotTimeOfDayValue: Option[TimeOfDay] =
      scala.Option(impl.nextSnapshotTimeOfDay()).map(value => value: TimeOfDay)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AddOn
  ): io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly = new Wrapper(impl)
}
