package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRelationalDatabaseParametersRequest(
    relationalDatabaseName: ResourceName,
    parameters: Iterable[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest = {
    import UpdateRelationalDatabaseParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersRequest
      .wrap(buildAwsValue())
}
object UpdateRelationalDatabaseParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersRequest =
      io.github.vigoo.zioaws.lightsail.model
        .UpdateRelationalDatabaseParametersRequest(
          relationalDatabaseNameValue,
          parametersValue.map { item =>
            item.editable
          }
        )
    def relationalDatabaseNameValue: ResourceName
    def parametersValue: List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def parameters: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ]] = ZIO.succeed(parametersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def parametersValue: List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ] = impl
      .parameters()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateRelationalDatabaseParametersRequest.ReadOnly =
    new Wrapper(impl)
}
