package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDomainEntryRequest(
    domainName: DomainName,
    domainEntry: io.github.vigoo.zioaws.lightsail.model.DomainEntry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest = {
    import UpdateDomainEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .domainEntry(domainEntry.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryRequest
      .wrap(buildAwsValue())
}
object UpdateDomainEntryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryRequest =
      io.github.vigoo.zioaws.lightsail.model
        .UpdateDomainEntryRequest(domainNameValue, domainEntryValue.editable)
    def domainNameValue: DomainName
    def domainEntryValue
        : io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly
    def domainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainNameValue)
    def domainEntry: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly
    ] = ZIO.succeed(domainEntryValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryRequest.ReadOnly {
    override def domainNameValue: DomainName = impl.domainName(): DomainName
    override def domainEntryValue
        : io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.DomainEntry
        .wrap(impl.domainEntry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateDomainEntryRequest.ReadOnly =
    new Wrapper(impl)
}
