package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDistributionBundleRequest(
    distributionName: Option[ResourceName] = None,
    bundleId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest = {
    import UpdateDistributionBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
      .builder()
      .optionallyWith(distributionName.map(value => value: java.lang.String))(
        _.distributionName
      )
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleRequest
      .wrap(buildAwsValue())
}
object UpdateDistributionBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleRequest =
      io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleRequest(
        distributionNameValue.map(value => value),
        bundleIdValue.map(value => value)
      )
    def distributionNameValue: Option[ResourceName]
    def bundleIdValue: Option[String]
    def distributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionNameValue)
    def bundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleRequest.ReadOnly {
    override def distributionNameValue: Option[ResourceName] =
      scala.Option(impl.distributionName()).map(value => value: ResourceName)
    override def bundleIdValue: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateDistributionBundleRequest.ReadOnly =
    new Wrapper(impl)
}
