package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBucketRequest(
    bucketName: BucketName,
    accessRules: Option[io.github.vigoo.zioaws.lightsail.model.AccessRules] =
      None,
    versioning: Option[NonEmptyString] = None,
    readonlyAccessAccounts: Option[Iterable[NonEmptyString]] = None,
    accessLogConfig: Option[
      io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest = {
    import UpdateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
      .builder()
      .bucketName(bucketName: java.lang.String)
      .optionallyWith(accessRules.map(value => value.buildAwsValue()))(
        _.accessRules
      )
      .optionallyWith(versioning.map(value => value: java.lang.String))(
        _.versioning
      )
      .optionallyWith(
        readonlyAccessAccounts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readonlyAccessAccounts)
      .optionallyWith(accessLogConfig.map(value => value.buildAwsValue()))(
        _.accessLogConfig
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateBucketRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateBucketRequest
      .wrap(buildAwsValue())
}
object UpdateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.UpdateBucketRequest =
      io.github.vigoo.zioaws.lightsail.model.UpdateBucketRequest(
        bucketNameValue,
        accessRulesValue.map(value => value.editable),
        versioningValue.map(value => value),
        readonlyAccessAccountsValue.map(value => value),
        accessLogConfigValue.map(value => value.editable)
      )
    def bucketNameValue: BucketName
    def accessRulesValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly]
    def versioningValue: Option[NonEmptyString]
    def readonlyAccessAccountsValue: Option[List[NonEmptyString]]
    def accessLogConfigValue: Option[
      io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig.ReadOnly
    ]
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def accessRules: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly
    ] = AwsError.unwrapOptionField("accessRules", accessRulesValue)
    def versioning: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versioning", versioningValue)
    def readonlyAccessAccounts: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "readonlyAccessAccounts",
        readonlyAccessAccountsValue
      )
    def accessLogConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogConfig", accessLogConfigValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateBucketRequest.ReadOnly {
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def accessRulesValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly] =
      scala
        .Option(impl.accessRules())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.AccessRules.wrap(value)
        )
    override def versioningValue: Option[NonEmptyString] =
      scala.Option(impl.versioning()).map(value => value: NonEmptyString)
    override def readonlyAccessAccountsValue: Option[List[NonEmptyString]] =
      scala
        .Option(impl.readonlyAccessAccounts())
        .map(value =>
          value.asScala.map { item =>
            item: NonEmptyString
          }.toList
        )
    override def accessLogConfigValue: Option[
      io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig.ReadOnly
    ] = scala
      .Option(impl.accessLogConfig())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
  ): io.github.vigoo.zioaws.lightsail.model.UpdateBucketRequest.ReadOnly =
    new Wrapper(impl)
}
