package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UntagResourceResponse(
    operations: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Operation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UntagResourceResponse = {
    import UntagResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse
      .wrap(buildAwsValue())
}
object UntagResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse =
      io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse(
        operationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ]
    def operations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ]] = AwsError.unwrapOptionField("operations", operationsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly {
    override def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceResponse
  ): io.github.vigoo.zioaws.lightsail.model.UntagResourceResponse.ReadOnly =
    new Wrapper(impl)
}
