package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestAlarmRequest(
    alarmName: ResourceName,
    state: io.github.vigoo.zioaws.lightsail.model.AlarmState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.TestAlarmRequest = {
    import TestAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
      .builder()
      .alarmName(alarmName: java.lang.String)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.TestAlarmRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.TestAlarmRequest
      .wrap(buildAwsValue())
}
object TestAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.TestAlarmRequest =
      io.github.vigoo.zioaws.lightsail.model
        .TestAlarmRequest(alarmNameValue, stateValue)
    def alarmNameValue: ResourceName
    def stateValue: io.github.vigoo.zioaws.lightsail.model.AlarmState
    def alarmName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(alarmNameValue)
    def state
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.AlarmState] =
      ZIO.succeed(stateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.TestAlarmRequest.ReadOnly {
    override def alarmNameValue: ResourceName = impl.alarmName(): ResourceName
    override def stateValue: io.github.vigoo.zioaws.lightsail.model.AlarmState =
      io.github.vigoo.zioaws.lightsail.model.AlarmState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
  ): io.github.vigoo.zioaws.lightsail.model.TestAlarmRequest.ReadOnly =
    new Wrapper(impl)
}
