package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{TagValue, TagKey}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Tag(
    key: Option[TagKey] = None,
    value: Option[TagValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Tag
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Tag =
      io.github.vigoo.zioaws.lightsail.model
        .Tag(keyValue.map(value => value), valueValue.map(value => value))
    def keyValue: Option[TagKey]
    def valueValue: Option[TagValue]
    def key: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def value: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Tag
  ) extends io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly {
    override def keyValue: Option[TagKey] =
      scala.Option(impl.key()).map(value => value: TagKey)
    override def valueValue: Option[TagValue] =
      scala.Option(impl.value()).map(value => value: TagValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Tag
  ): io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly = new Wrapper(impl)
}
