package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IpAddress,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StaticIp(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    ipAddress: Option[IpAddress] = None,
    attachedTo: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StaticIp = {
    import StaticIp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StaticIp
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(attachedTo.map(value => value: java.lang.String))(
        _.attachedTo
      )
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.StaticIp.wrap(buildAwsValue())
}
object StaticIp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StaticIp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.StaticIp =
      io.github.vigoo.zioaws.lightsail.model.StaticIp(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        ipAddressValue.map(value => value),
        attachedToValue.map(value => value),
        isAttachedValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def ipAddressValue: Option[IpAddress]
    def attachedToValue: Option[ResourceName]
    def isAttachedValue: Option[Boolean]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def ipAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddressValue)
    def attachedTo: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("attachedTo", attachedToValue)
    def isAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttachedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StaticIp
  ) extends io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def ipAddressValue: Option[IpAddress] =
      scala.Option(impl.ipAddress()).map(value => value: IpAddress)
    override def attachedToValue: Option[ResourceName] =
      scala.Option(impl.attachedTo()).map(value => value: ResourceName)
    override def isAttachedValue: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StaticIp
  ): io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly = new Wrapper(
    impl
  )
}
