package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceRecord(
    name: Option[String] = None,
    `type`: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResourceRecord = {
    import ResourceRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceRecord
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ResourceRecord.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ResourceRecord.wrap(buildAwsValue())
}
object ResourceRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResourceRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ResourceRecord =
      io.github.vigoo.zioaws.lightsail.model.ResourceRecord(
        nameValue.map(value => value),
        typeValue.map(value => value),
        valueValue.map(value => value)
      )
    def nameValue: Option[String]
    def typeValue: Option[String]
    def valueValue: Option[String]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def `type`: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", typeValue)
    def value: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceRecord
  ) extends io.github.vigoo.zioaws.lightsail.model.ResourceRecord.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def typeValue: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override def valueValue: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceRecord
  ): io.github.vigoo.zioaws.lightsail.model.ResourceRecord.ReadOnly =
    new Wrapper(impl)
}
