package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResetDistributionCacheRequest(
    distributionName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest = {
    import ResetDistributionCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest
      .builder()
      .optionallyWith(distributionName.map(value => value: java.lang.String))(
        _.distributionName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheRequest
      .wrap(buildAwsValue())
}
object ResetDistributionCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheRequest =
      io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheRequest(
        distributionNameValue.map(value => value)
      )
    def distributionNameValue: Option[ResourceName]
    def distributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheRequest.ReadOnly {
    override def distributionNameValue: Option[ResourceName] =
      scala.Option(impl.distributionName()).map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest
  ): io.github.vigoo.zioaws.lightsail.model.ResetDistributionCacheRequest.ReadOnly =
    new Wrapper(impl)
}
