package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  RenewalStatusReason
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RenewalSummary(
    domainValidationRecords: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord]
    ] = None,
    renewalStatus: Option[
      io.github.vigoo.zioaws.lightsail.model.RenewalStatus
    ] = None,
    renewalStatusReason: Option[RenewalStatusReason] = None,
    updatedAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RenewalSummary = {
    import RenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RenewalSummary
      .builder()
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(renewalStatus.map(value => value.unwrap))(_.renewalStatus)
      .optionallyWith(
        renewalStatusReason.map(value => value: java.lang.String)
      )(_.renewalStatusReason)
      .optionallyWith(updatedAt.map(value => value: Instant))(_.updatedAt)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RenewalSummary.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RenewalSummary.wrap(buildAwsValue())
}
object RenewalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RenewalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.RenewalSummary =
      io.github.vigoo.zioaws.lightsail.model.RenewalSummary(
        domainValidationRecordsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        renewalStatusValue.map(value => value),
        renewalStatusReasonValue.map(value => value),
        updatedAtValue.map(value => value)
      )
    def domainValidationRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly
    ]]
    def renewalStatusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RenewalStatus]
    def renewalStatusReasonValue: Option[RenewalStatusReason]
    def updatedAtValue: Option[IsoDate]
    def domainValidationRecords: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecordsValue
    )
    def renewalStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RenewalStatus
    ] = AwsError.unwrapOptionField("renewalStatus", renewalStatusValue)
    def renewalStatusReason: ZIO[Any, AwsError, RenewalStatusReason] = AwsError
      .unwrapOptionField("renewalStatusReason", renewalStatusReasonValue)
    def updatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("updatedAt", updatedAtValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RenewalSummary
  ) extends io.github.vigoo.zioaws.lightsail.model.RenewalSummary.ReadOnly {
    override def domainValidationRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly
    ]] = scala
      .Option(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord
            .wrap(item)
        }.toList
      )
    override def renewalStatusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RenewalStatus] = scala
      .Option(impl.renewalStatus())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RenewalStatus.wrap(value)
      )
    override def renewalStatusReasonValue: Option[RenewalStatusReason] = scala
      .Option(impl.renewalStatusReason())
      .map(value => value: RenewalStatusReason)
    override def updatedAtValue: Option[IsoDate] =
      scala.Option(impl.updatedAt()).map(value => value: IsoDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RenewalSummary
  ): io.github.vigoo.zioaws.lightsail.model.RenewalSummary.ReadOnly =
    new Wrapper(impl)
}
