package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  Integer
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseEndpoint(
    port: Option[Integer] = None,
    address: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint = {
    import RelationalDatabaseEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
      .builder()
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint
      .wrap(buildAwsValue())
}
object RelationalDatabaseEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint(
        portValue.map(value => value),
        addressValue.map(value => value)
      )
    def portValue: Option[Integer]
    def addressValue: Option[NonEmptyString]
    def port: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", portValue)
    def address: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("address", addressValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly {
    override def portValue: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override def addressValue: Option[NonEmptyString] =
      scala.Option(impl.address()).map(value => value: NonEmptyString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly =
    new Wrapper(impl)
}
