package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseBlueprint(
    blueprintId: Option[String] = None,
    engine: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEngine
    ] = None,
    engineVersion: Option[String] = None,
    engineDescription: Option[String] = None,
    engineVersionDescription: Option[String] = None,
    isEngineDefault: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint = {
    import RelationalDatabaseBlueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
      .builder()
      .optionallyWith(blueprintId.map(value => value: java.lang.String))(
        _.blueprintId
      )
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(engineDescription.map(value => value: java.lang.String))(
        _.engineDescription
      )
      .optionallyWith(
        engineVersionDescription.map(value => value: java.lang.String)
      )(_.engineVersionDescription)
      .optionallyWith(isEngineDefault.map(value => value: java.lang.Boolean))(
        _.isEngineDefault
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint
      .wrap(buildAwsValue())
}
object RelationalDatabaseBlueprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint(
        blueprintIdValue.map(value => value),
        engineValue.map(value => value),
        engineVersionValue.map(value => value),
        engineDescriptionValue.map(value => value),
        engineVersionDescriptionValue.map(value => value),
        isEngineDefaultValue.map(value => value)
      )
    def blueprintIdValue: Option[String]
    def engineValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEngine
    ]
    def engineVersionValue: Option[String]
    def engineDescriptionValue: Option[String]
    def engineVersionDescriptionValue: Option[String]
    def isEngineDefaultValue: Option[Boolean]
    def blueprintId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("blueprintId", blueprintIdValue)
    def engine: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEngine
    ] = AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def engineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineDescription", engineDescriptionValue)
    def engineVersionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "engineVersionDescription",
        engineVersionDescriptionValue
      )
    def isEngineDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEngineDefault", isEngineDefaultValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly {
    override def blueprintIdValue: Option[String] =
      scala.Option(impl.blueprintId()).map(value => value: String)
    override def engineValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEngine
    ] = scala
      .Option(impl.engine())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEngine
          .wrap(value)
      )
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def engineDescriptionValue: Option[String] =
      scala.Option(impl.engineDescription()).map(value => value: String)
    override def engineVersionDescriptionValue: Option[String] =
      scala.Option(impl.engineVersionDescription()).map(value => value: String)
    override def isEngineDefaultValue: Option[Boolean] =
      scala.Option(impl.isEngineDefault()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly =
    new Wrapper(impl)
}
