package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{Integer, ResourceName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutAlarmRequest(
    alarmName: ResourceName,
    metricName: io.github.vigoo.zioaws.lightsail.model.MetricName,
    monitoredResourceName: ResourceName,
    comparisonOperator: io.github.vigoo.zioaws.lightsail.model.ComparisonOperator,
    threshold: Double,
    evaluationPeriods: Integer,
    datapointsToAlarm: Option[Integer] = None,
    treatMissingData: Option[
      io.github.vigoo.zioaws.lightsail.model.TreatMissingData
    ] = None,
    contactProtocols: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]
    ] = None,
    notificationTriggers: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AlarmState]
    ] = None,
    notificationEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PutAlarmRequest = {
    import PutAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
      .builder()
      .alarmName(alarmName: java.lang.String)
      .metricName(metricName.unwrap)
      .monitoredResourceName(monitoredResourceName: java.lang.String)
      .comparisonOperator(comparisonOperator.unwrap)
      .threshold(threshold: java.lang.Double)
      .evaluationPeriods(evaluationPeriods: java.lang.Integer)
      .optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(treatMissingData.map(value => value.unwrap))(
        _.treatMissingData
      )
      .optionallyWith(
        contactProtocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contactProtocolsWithStrings)
      .optionallyWith(
        notificationTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationTriggersWithStrings)
      .optionallyWith(
        notificationEnabled.map(value => value: java.lang.Boolean)
      )(_.notificationEnabled)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.PutAlarmRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.PutAlarmRequest.wrap(buildAwsValue())
}
object PutAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.PutAlarmRequest =
      io.github.vigoo.zioaws.lightsail.model.PutAlarmRequest(
        alarmNameValue,
        metricNameValue,
        monitoredResourceNameValue,
        comparisonOperatorValue,
        thresholdValue,
        evaluationPeriodsValue,
        datapointsToAlarmValue.map(value => value),
        treatMissingDataValue.map(value => value),
        contactProtocolsValue.map(value => value),
        notificationTriggersValue.map(value => value),
        notificationEnabledValue.map(value => value)
      )
    def alarmNameValue: ResourceName
    def metricNameValue: io.github.vigoo.zioaws.lightsail.model.MetricName
    def monitoredResourceNameValue: ResourceName
    def comparisonOperatorValue
        : io.github.vigoo.zioaws.lightsail.model.ComparisonOperator
    def thresholdValue: Double
    def evaluationPeriodsValue: Integer
    def datapointsToAlarmValue: Option[Integer]
    def treatMissingDataValue
        : Option[io.github.vigoo.zioaws.lightsail.model.TreatMissingData]
    def contactProtocolsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]]
    def notificationTriggersValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AlarmState]]
    def notificationEnabledValue: Option[Boolean]
    def alarmName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(alarmNameValue)
    def metricName
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.MetricName] =
      ZIO.succeed(metricNameValue)
    def monitoredResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(monitoredResourceNameValue)
    def comparisonOperator: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ComparisonOperator
    ] = ZIO.succeed(comparisonOperatorValue)
    def threshold: ZIO[Any, Nothing, Double] = ZIO.succeed(thresholdValue)
    def evaluationPeriods: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(evaluationPeriodsValue)
    def datapointsToAlarm: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarmValue)
    def treatMissingData: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.TreatMissingData
    ] = AwsError.unwrapOptionField("treatMissingData", treatMissingDataValue)
    def contactProtocols: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    ]] = AwsError.unwrapOptionField("contactProtocols", contactProtocolsValue)
    def notificationTriggers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AlarmState
    ]] = AwsError.unwrapOptionField(
      "notificationTriggers",
      notificationTriggersValue
    )
    def notificationEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("notificationEnabled", notificationEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.PutAlarmRequest.ReadOnly {
    override def alarmNameValue: ResourceName = impl.alarmName(): ResourceName
    override def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.MetricName =
      io.github.vigoo.zioaws.lightsail.model.MetricName.wrap(impl.metricName())
    override def monitoredResourceNameValue: ResourceName =
      impl.monitoredResourceName(): ResourceName
    override def comparisonOperatorValue
        : io.github.vigoo.zioaws.lightsail.model.ComparisonOperator =
      io.github.vigoo.zioaws.lightsail.model.ComparisonOperator
        .wrap(impl.comparisonOperator())
    override def thresholdValue: Double = impl.threshold(): Double
    override def evaluationPeriodsValue: Integer =
      impl.evaluationPeriods(): Integer
    override def datapointsToAlarmValue: Option[Integer] =
      scala.Option(impl.datapointsToAlarm()).map(value => value: Integer)
    override def treatMissingDataValue
        : Option[io.github.vigoo.zioaws.lightsail.model.TreatMissingData] =
      scala
        .Option(impl.treatMissingData())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.TreatMissingData.wrap(value)
        )
    override def contactProtocolsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]] =
      scala
        .Option(impl.contactProtocols())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.ContactProtocol.wrap(item)
          }.toList
        )
    override def notificationTriggersValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AlarmState]] =
      scala
        .Option(impl.notificationTriggers())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.AlarmState.wrap(item)
          }.toList
        )
    override def notificationEnabledValue: Option[Boolean] =
      scala.Option(impl.notificationEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PutAlarmRequest
  ): io.github.vigoo.zioaws.lightsail.model.PutAlarmRequest.ReadOnly =
    new Wrapper(impl)
}
