package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PendingModifiedRelationalDatabaseValues(
    masterUserPassword: Option[String] = None,
    engineVersion: Option[String] = None,
    backupRetentionEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues = {
    import PendingModifiedRelationalDatabaseValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
      .builder()
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        backupRetentionEnabled.map(value => value: java.lang.Boolean)
      )(_.backupRetentionEnabled)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues
      .wrap(buildAwsValue())
}
object PendingModifiedRelationalDatabaseValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues =
      io.github.vigoo.zioaws.lightsail.model
        .PendingModifiedRelationalDatabaseValues(
          masterUserPasswordValue.map(value => value),
          engineVersionValue.map(value => value),
          backupRetentionEnabledValue.map(value => value)
        )
    def masterUserPasswordValue: Option[String]
    def engineVersionValue: Option[String]
    def backupRetentionEnabledValue: Option[Boolean]
    def masterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def engineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def backupRetentionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("backupRetentionEnabled", backupRetentionEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ) extends io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly {
    override def masterUserPasswordValue: Option[String] =
      scala.Option(impl.masterUserPassword()).map(value => value: String)
    override def engineVersionValue: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override def backupRetentionEnabledValue: Option[Boolean] =
      scala.Option(impl.backupRetentionEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ): io.github.vigoo.zioaws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly =
    new Wrapper(impl)
}
