package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PendingMaintenanceAction(
    action: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    currentApplyDate: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction = {
    import PendingMaintenanceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
      .builder()
      .optionallyWith(action.map(value => value: java.lang.String))(_.action)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(currentApplyDate.map(value => value: Instant))(
        _.currentApplyDate
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction
      .wrap(buildAwsValue())
}
object PendingMaintenanceAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction =
      io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction(
        actionValue.map(value => value),
        descriptionValue.map(value => value),
        currentApplyDateValue.map(value => value)
      )
    def actionValue: Option[NonEmptyString]
    def descriptionValue: Option[NonEmptyString]
    def currentApplyDateValue: Option[IsoDate]
    def action: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("action", actionValue)
    def description: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def currentApplyDate: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("currentApplyDate", currentApplyDateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
  ) extends io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction.ReadOnly {
    override def actionValue: Option[NonEmptyString] =
      scala.Option(impl.action()).map(value => value: NonEmptyString)
    override def descriptionValue: Option[NonEmptyString] =
      scala.Option(impl.description()).map(value => value: NonEmptyString)
    override def currentApplyDateValue: Option[IsoDate] =
      scala.Option(impl.currentApplyDate()).map(value => value: IsoDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
  ): io.github.vigoo.zioaws.lightsail.model.PendingMaintenanceAction.ReadOnly =
    new Wrapper(impl)
}
