package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MonthlyTransfer(gbPerMonthAllocated: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MonthlyTransfer = {
    import MonthlyTransfer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
      .builder()
      .optionallyWith(
        gbPerMonthAllocated.map(value => value: java.lang.Integer)
      )(_.gbPerMonthAllocated)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.wrap(buildAwsValue())
}
object MonthlyTransfer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer =
      io.github.vigoo.zioaws.lightsail.model
        .MonthlyTransfer(gbPerMonthAllocatedValue.map(value => value))
    def gbPerMonthAllocatedValue: Option[Integer]
    def gbPerMonthAllocated: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("gbPerMonthAllocated", gbPerMonthAllocatedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ) extends io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.ReadOnly {
    override def gbPerMonthAllocatedValue: Option[Integer] =
      scala.Option(impl.gbPerMonthAllocated()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ): io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.ReadOnly =
    new Wrapper(impl)
}
