package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ResourceName,
  ResourceArn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MonitoredResourceInfo(
    arn: Option[ResourceArn] = None,
    name: Option[ResourceName] = None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo = {
    import MonitoredResourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo
      .wrap(buildAwsValue())
}
object MonitoredResourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo =
      io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo(
        arnValue.map(value => value),
        nameValue.map(value => value),
        resourceTypeValue.map(value => value)
      )
    def arnValue: Option[ResourceArn]
    def nameValue: Option[ResourceName]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def arn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo.ReadOnly {
    override def arnValue: Option[ResourceArn] =
      scala.Option(impl.arn()).map(value => value: ResourceArn)
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo
  ): io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo.ReadOnly =
    new Wrapper(impl)
}
