package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  DomainName,
  NonEmptyString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificateDomainValidationRecord(
    name: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None,
    value: Option[NonEmptyString] = None,
    validationStatus: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = None,
    domainName: Option[DomainName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord = {
    import LoadBalancerTlsCertificateDomainValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDomainValidationRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord =
      io.github.vigoo.zioaws.lightsail.model
        .LoadBalancerTlsCertificateDomainValidationRecord(
          nameValue.map(value => value),
          typeValue.map(value => value),
          valueValue.map(value => value),
          validationStatusValue.map(value => value),
          domainNameValue.map(value => value)
        )
    def nameValue: Option[NonEmptyString]
    def typeValue: Option[NonEmptyString]
    def valueValue: Option[NonEmptyString]
    def validationStatusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ]
    def domainNameValue: Option[DomainName]
    def name: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", nameValue)
    def `type`: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", typeValue)
    def value: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", valueValue)
    def validationStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatusValue)
    def domainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ) extends io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly {
    override def nameValue: Option[NonEmptyString] =
      scala.Option(impl.name()).map(value => value: NonEmptyString)
    override def typeValue: Option[NonEmptyString] =
      scala.Option(impl.`type`()).map(value => value: NonEmptyString)
    override def valueValue: Option[NonEmptyString] =
      scala.Option(impl.value()).map(value => value: NonEmptyString)
    override def validationStatusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = scala
      .Option(impl.validationStatus())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
          .wrap(value)
      )
    override def domainNameValue: Option[DomainName] =
      scala.Option(impl.domainName()).map(value => value: DomainName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ): io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly =
    new Wrapper(impl)
}
