package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceHealthSummary(
    instanceName: Option[ResourceName] = None,
    instanceHealth: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthState
    ] = None,
    instanceHealthReason: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthReason
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary = {
    import InstanceHealthSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
      .builder()
      .optionallyWith(instanceName.map(value => value: java.lang.String))(
        _.instanceName
      )
      .optionallyWith(instanceHealth.map(value => value.unwrap))(
        _.instanceHealth
      )
      .optionallyWith(instanceHealthReason.map(value => value.unwrap))(
        _.instanceHealthReason
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary
      .wrap(buildAwsValue())
}
object InstanceHealthSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary =
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary(
        instanceNameValue.map(value => value),
        instanceHealthValue.map(value => value),
        instanceHealthReasonValue.map(value => value)
      )
    def instanceNameValue: Option[ResourceName]
    def instanceHealthValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceHealthState]
    def instanceHealthReasonValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceHealthReason]
    def instanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def instanceHealth: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthState
    ] = AwsError.unwrapOptionField("instanceHealth", instanceHealthValue)
    def instanceHealthReason: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthReason
    ] = AwsError.unwrapOptionField(
      "instanceHealthReason",
      instanceHealthReasonValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary.ReadOnly {
    override def instanceNameValue: Option[ResourceName] =
      scala.Option(impl.instanceName()).map(value => value: ResourceName)
    override def instanceHealthValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceHealthState] =
      scala
        .Option(impl.instanceHealth())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.InstanceHealthState.wrap(value)
        )
    override def instanceHealthReasonValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceHealthReason] =
      scala
        .Option(impl.instanceHealthReason())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.InstanceHealthReason
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
  ): io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary.ReadOnly =
    new Wrapper(impl)
}
