package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ResourceName,
  IpAddress,
  IsoDate
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceAccessDetails(
    certKey: Option[String] = None,
    expiresAt: Option[IsoDate] = None,
    ipAddress: Option[IpAddress] = None,
    password: Option[String] = None,
    passwordData: Option[io.github.vigoo.zioaws.lightsail.model.PasswordData] =
      None,
    privateKey: Option[String] = None,
    protocol: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
    ] = None,
    instanceName: Option[ResourceName] = None,
    username: Option[String] = None,
    hostKeys: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails = {
    import InstanceAccessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
      .builder()
      .optionallyWith(certKey.map(value => value: java.lang.String))(_.certKey)
      .optionallyWith(expiresAt.map(value => value: Instant))(_.expiresAt)
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(password.map(value => value: java.lang.String))(
        _.password
      )
      .optionallyWith(passwordData.map(value => value.buildAwsValue()))(
        _.passwordData
      )
      .optionallyWith(privateKey.map(value => value: java.lang.String))(
        _.privateKey
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(instanceName.map(value => value: java.lang.String))(
        _.instanceName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        hostKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hostKeys)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails
      .wrap(buildAwsValue())
}
object InstanceAccessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails =
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails(
        certKeyValue.map(value => value),
        expiresAtValue.map(value => value),
        ipAddressValue.map(value => value),
        passwordValue.map(value => value),
        passwordDataValue.map(value => value.editable),
        privateKeyValue.map(value => value),
        protocolValue.map(value => value),
        instanceNameValue.map(value => value),
        usernameValue.map(value => value),
        hostKeysValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def certKeyValue: Option[String]
    def expiresAtValue: Option[IsoDate]
    def ipAddressValue: Option[IpAddress]
    def passwordValue: Option[String]
    def passwordDataValue
        : Option[io.github.vigoo.zioaws.lightsail.model.PasswordData.ReadOnly]
    def privateKeyValue: Option[String]
    def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol]
    def instanceNameValue: Option[ResourceName]
    def usernameValue: Option[String]
    def hostKeysValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes.ReadOnly]
    ]
    def certKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certKey", certKeyValue)
    def expiresAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("expiresAt", expiresAtValue)
    def ipAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddressValue)
    def password: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("password", passwordValue)
    def passwordData: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.PasswordData.ReadOnly
    ] = AwsError.unwrapOptionField("passwordData", passwordDataValue)
    def privateKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateKey", privateKeyValue)
    def protocol: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
    ] = AwsError.unwrapOptionField("protocol", protocolValue)
    def instanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def username: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", usernameValue)
    def hostKeys: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("hostKeys", hostKeysValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails.ReadOnly {
    override def certKeyValue: Option[String] =
      scala.Option(impl.certKey()).map(value => value: String)
    override def expiresAtValue: Option[IsoDate] =
      scala.Option(impl.expiresAt()).map(value => value: IsoDate)
    override def ipAddressValue: Option[IpAddress] =
      scala.Option(impl.ipAddress()).map(value => value: IpAddress)
    override def passwordValue: Option[String] =
      scala.Option(impl.password()).map(value => value: String)
    override def passwordDataValue
        : Option[io.github.vigoo.zioaws.lightsail.model.PasswordData.ReadOnly] =
      scala
        .Option(impl.passwordData())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.PasswordData.wrap(value)
        )
    override def privateKeyValue: Option[String] =
      scala.Option(impl.privateKey()).map(value => value: String)
    override def protocolValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
    ] = scala
      .Option(impl.protocol())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol
          .wrap(value)
      )
    override def instanceNameValue: Option[ResourceName] =
      scala.Option(impl.instanceName()).map(value => value: ResourceName)
    override def usernameValue: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override def hostKeysValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes.ReadOnly]
    ] = scala
      .Option(impl.hostKeys())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ): io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails.ReadOnly =
    new Wrapper(impl)
}
