package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabasesResponse(
    relationalDatabases: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.RelationalDatabase]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse = {
    import GetRelationalDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
      .builder()
      .optionallyWith(
        relationalDatabases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabases)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse(
        relationalDatabasesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def relationalDatabasesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly]
    ]
    def nextPageTokenValue: Option[String]
    def relationalDatabases: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relationalDatabases",
      relationalDatabasesValue
    )
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly {
    override def relationalDatabasesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly]
    ] = scala
      .Option(impl.relationalDatabases())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly =
    new Wrapper(impl)
}
