package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseSnapshotsResponse(
    relationalDatabaseSnapshots: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot
    ]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse = {
    import GetRelationalDatabaseSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
      .builder()
      .optionallyWith(
        relationalDatabaseSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabaseSnapshots)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseSnapshotsResponse(
          relationalDatabaseSnapshotsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def relationalDatabaseSnapshotsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def relationalDatabaseSnapshots: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relationalDatabaseSnapshots",
      relationalDatabaseSnapshotsValue
    )
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly {
    override def relationalDatabaseSnapshotsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ]] = scala
      .Option(impl.relationalDatabaseSnapshots())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
