package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseSnapshotRequest(
    relationalDatabaseSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest = {
    import GetRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
      .builder()
      .relationalDatabaseSnapshotName(
        relationalDatabaseSnapshotName: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseSnapshotRequest(
          relationalDatabaseSnapshotNameValue
        )
    def relationalDatabaseSnapshotNameValue: ResourceName
    def relationalDatabaseSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseSnapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotRequest.ReadOnly {
    override def relationalDatabaseSnapshotNameValue: ResourceName =
      impl.relationalDatabaseSnapshotName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
